/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.deeplands;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;

public class EntityRockCrawler
extends AoAMeleeMob {
    public static final float entityWidth = 0.875f;
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityRockCrawler.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityRockCrawler(World world) {
        super(world, 0.875f, 1.9375f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateClimber((EntityLiving)this, world);
    }

    public float func_70047_e() {
        return 1.6875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 70.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 7.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.29;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobCaveBugLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobCaveBugDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobCaveBugHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.field_187823_fN;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityRockCrawler;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < 120.0 && super.func_70601_bi();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte climbingBit = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        climbingBit = climbing ? (byte)(climbingBit | 1) : (byte)(climbingBit & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbingBit);
    }
}

