/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.iromine;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityMechamaton
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 1.125f;

    public EntityMechamaton(World world) {
        super(world, 1.125f, 2.125f);
        this.mobProperties.add(Enums.MobProperties.MELEE_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
    }

    public float func_70047_e() {
        return 1.90625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 120.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 11.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.295;
    }

    @Override
    protected double getBaseArmour() {
        return 3.5;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobAutomatonLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobAutomatonDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobAutomatonHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.mobGolemStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityMechamaton;
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            double resist = 1.0;
            IAttributeInstance attrib = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c);
            if (attrib != null) {
                resist -= attrib.func_111126_e();
            }
            target.func_70024_g(this.field_70159_w * 5.0 * resist, this.field_70181_x * 1.3 * resist, this.field_70179_y * 5.0 * resist);
            target.field_70133_I = true;
        }
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isMeleeDamage(source) || EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

