/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityGhostineAncient
extends AoAMeleeMob {
    public static final float entityWidth = 0.9f;

    public EntityGhostineAncient(World world) {
        super(world, 0.9f, 2.1f);
    }

    public float func_70047_e() {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 30.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 3.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobGhostineLiving;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobGhostineDeath;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobGhostineHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityGhostineAncient;
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityPlayer) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)target);
            plData.stats().consumeResource(Enums.Resources.SOUL, plData.stats().getResourceValue(Enums.Resources.SOUL) / 1.5f, true);
            plData.sendThrottledChatMessage("message.mob.ghostineAncient.attack", new Object[0]);
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }
}

