/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld;

import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntitySandGolem
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.75f;

    public EntitySandGolem(World world) {
        super(world, 0.75f, 1.8125f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    public float func_70047_e() {
        return 1.6875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 45.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 4.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    @Override
    protected double getBaseArmour() {
        return 8.0;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187602_cF;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.field_187605_cG;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entitySandGolem;
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isRangedDamage(source, source.func_76364_f(), 1.0f) || EntityUtil.isGunDamage(source);
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

