/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld.bloodhunt;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityAnemiaBomb;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.WorldUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityAnemia
extends AoAFlyingRangedMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 2.25f;

    public EntityAnemia(World world) {
        super(world, 2.25f, 3.0f);
        this.mobProperties.add(Enums.MobProperties.BLASTER_IMMUNE);
    }

    public float func_70047_e() {
        return 2.0625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.5;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 70.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 10.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobAnemiaLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobAnemiaDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobAnemiaHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityAnemia;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityAnemiaBomb(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityPlayer) {
            PlayerUtil.consumeResource((EntityPlayer)target, Enums.Resources.ENERGY, 50.0f, true);
        }
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    protected double getSpawnChanceFactor() {
        return ConfigurationUtil.EntityConfig.mobSpawnFrequencyModifier / 4.0;
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isBlasterDamage(source);
    }

    @Override
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    @Override
    @Nonnull
    protected Enums.CreatureEvents getEventRequirement() {
        return Enums.CreatureEvents.BLOOD_HUNT;
    }
}

