/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectiles.arrow;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.projectiles.HardProjectile;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.item.weapon.bow.BaseBow;

public class EntityTippedHollyArrow
extends EntityHollyArrow
implements HardProjectile {
    private static final DataParameter<Integer> colour = EntityDataManager.func_187226_a(EntityTippedHollyArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private PotionType potion = PotionTypes.field_185229_a;
    private final Set<PotionEffect> customPotionEffects = Sets.newHashSet();
    private boolean fixedColour;

    public EntityTippedHollyArrow(World worldIn) {
        super(worldIn);
    }

    public EntityTippedHollyArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityTippedHollyArrow(World world, BaseBow bow, EntityLivingBase shooter, double damageBase) {
        super(world, bow, shooter, damageBase);
    }

    public void setPotionEffect(ItemStack ammo) {
        if (ammo.func_77973_b() == ItemRegister.hollyArrowTipped) {
            int i;
            this.potion = PotionUtils.func_185191_c((ItemStack)ammo);
            List collection = PotionUtils.func_185190_b((ItemStack)ammo);
            if (!collection.isEmpty()) {
                for (PotionEffect effect : collection) {
                    this.customPotionEffects.add(new PotionEffect(effect));
                }
            }
            if ((i = EntityTippedHollyArrow.getCustomColour(ammo)) == -1) {
                this.refreshColour();
            } else {
                this.setFixedColour(i);
            }
        }
    }

    public static int getCustomColour(ItemStack ammo) {
        NBTTagCompound nbt = ammo.func_77978_p();
        return nbt != null && nbt.func_150297_b("CustomPotionColour", 99) ? nbt.func_74762_e("CustomPotionColour") : -1;
    }

    private void refreshColour() {
        this.fixedColour = false;
        this.field_70180_af.func_187227_b(colour, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((PotionType)this.potion, this.customPotionEffects)));
    }

    public void addEffect(PotionEffect effect) {
        this.customPotionEffects.add(effect);
        this.func_184212_Q().func_187227_b(colour, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((PotionType)this.potion, this.customPotionEffects)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(colour, (Object)-1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.customPotionEffects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.potion = PotionTypes.field_185229_a;
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(colour, (Object)-1);
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int colour = this.getColour();
        if (colour != -1 && particleCount > 0) {
            double red = (double)(colour >> 16 & 0xFF) / 255.0;
            double green = (double)(colour >> 8 & 0xFF) / 255.0;
            double blue = (double)(colour & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, red, green, blue, new int[0]);
            }
        }
    }

    public int getColour() {
        return (Integer)this.field_70180_af.func_187225_a(colour);
    }

    private void setFixedColour(int value) {
        this.fixedColour = true;
        this.field_70180_af.func_187227_b(colour, (Object)value);
    }

    @Override
    protected void func_184548_a(EntityLivingBase target) {
        super.func_184548_a(target);
        for (PotionEffect effect : this.potion.func_185170_a()) {
            target.func_70690_d(new PotionEffect(effect.func_188419_a(), Math.max(effect.func_76459_b() / 2, 1), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (PotionEffect effect : this.customPotionEffects) {
                target.func_70690_d(effect);
            }
        }
    }

    @Override
    protected ItemStack func_184550_j() {
        if (this.customPotionEffects.isEmpty() && this.potion == PotionTypes.field_185229_a) {
            return new ItemStack((Item)ItemRegister.hollyArrow);
        }
        ItemStack arrowStack = new ItemStack((Item)ItemRegister.hollyArrowTipped);
        PotionUtils.func_185188_a((ItemStack)arrowStack, (PotionType)this.potion);
        PotionUtils.func_185184_a((ItemStack)arrowStack, this.customPotionEffects);
        if (this.fixedColour) {
            NBTTagCompound nbt = arrowStack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                arrowStack.func_77982_d(nbt);
            }
            nbt.func_74768_a("CustomPotionColour", this.getColour());
        }
        return arrowStack;
    }

    public Potion getBasePotionEffect() {
        return ((PotionEffect)this.potion.func_185170_a().get(0)).func_188419_a();
    }

    @Override
    public void doImpactEffect() {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int colour = this.getColour();
            if (colour != -1) {
                double red = (double)(colour >> 16 & 0xFF) / 255.0;
                double green = (double)(colour >> 8 & 0xFF) / 255.0;
                double blue = (double)(colour & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, red, green, blue, new int[0]);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

