/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockVine;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.block.generation.stone.StoneBlock;
import net.tslat.aoa3.common.handlers.PlayerCrownHandler;
import net.tslat.aoa3.common.packet.PacketResourceData;
import net.tslat.aoa3.common.packet.PacketSkillData;
import net.tslat.aoa3.common.packet.PacketTributeData;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.dimension.AoAWorldProvider;
import net.tslat.aoa3.entity.misc.EntityAnimaStone;
import net.tslat.aoa3.entity.misc.EntityBloodlust;
import net.tslat.aoa3.event.custom.PlayerLevelChangeEvent;
import net.tslat.aoa3.event.dimension.CandylandEvents;
import net.tslat.aoa3.event.dimension.LelyetiaEvents;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.event.dimension.ShyrelandsEvents;
import net.tslat.aoa3.event.dimension.VoxPondsEvents;
import net.tslat.aoa3.item.misc.BlankRealmstone;
import net.tslat.aoa3.item.misc.ReservedItem;
import net.tslat.aoa3.item.misc.summon.BossSpawningItem;
import net.tslat.aoa3.item.tool.SpecialHarvestTool;
import net.tslat.aoa3.item.tool.misc.ExpFlask;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.WorldUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;
import net.tslat.aoa3.utils.skills.ButcheryUtil;
import net.tslat.aoa3.utils.skills.ExpeditionUtil;
import net.tslat.aoa3.utils.skills.ForagingUtil;
import net.tslat.aoa3.utils.skills.InnervationUtil;
import net.tslat.aoa3.utils.skills.LoggingUtil;
import org.apache.logging.log4j.Level;

public class PlayerEvents {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END && !ev.player.field_70170_p.field_72995_K) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(ev.player);
            plData.tickPlayer();
            if (!ev.player.field_70170_p.field_72995_K && !ev.player.field_71075_bZ.field_75098_d && ev.player.field_70122_E && !ev.player.func_184218_aH()) {
                ExpeditionUtil.handleRunningTick(ev, plData);
            }
            if (ev.player.field_71093_bK == ConfigurationUtil.MainConfig.dimensionIds.shyrelands) {
                ShyrelandsEvents.doPlayerTick(plData);
            } else if (ev.player.field_71093_bK == ConfigurationUtil.MainConfig.dimensionIds.lelyetia) {
                LelyetiaEvents.doPlayerTick(plData);
            } else if (ev.player.field_71093_bK == ConfigurationUtil.MainConfig.dimensionIds.voxPonds) {
                VoxPondsEvents.doPlayerTick(plData);
            } else if (ev.player.field_71093_bK == ConfigurationUtil.MainConfig.dimensionIds.candyland) {
                CandylandEvents.doPlayerTick(plData);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHit(LivingAttackEvent ev) {
        if (!ev.getEntity().field_70170_p.field_72995_K && ev.getEntity() instanceof EntityPlayer) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)ev.getEntity());
            plData.handleIncomingAttack(ev);
        }
    }

    @SubscribeEvent
    public void onPlayerLevelUp(PlayerLevelChangeEvent ev) {
        double healthBuff;
        if (ev.getSkill() == Enums.Skills.INNERVATION && (healthBuff = InnervationUtil.getHealthBuff(ev.getNewLevel())) != InnervationUtil.getHealthBuff(ev.getOldLevel())) {
            EntityUtil.removeAttributeModifier((EntityLivingBase)ev.getEntityPlayer(), SharedMonsterAttributes.field_111267_a, AoAAttributes.INNERVATION_HEALTH_BUFF);
            if (healthBuff > 0.0) {
                EntityUtil.applyAttributeModifierSafely((EntityLivingBase)ev.getEntityPlayer(), SharedMonsterAttributes.field_111267_a, AoAAttributes.innervationHealthBuff(healthBuff));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDamaged(LivingDamageEvent ev) {
        if (!ev.getEntityLiving().field_70170_p.field_72995_K && ev.getEntityLiving() instanceof EntityPlayer) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)ev.getEntityLiving());
            if (ev.getEntityLiving().func_110143_aJ() > 0.0f) {
                plData.handleDamageTriggers(ev);
                if (ev.getSource().func_76346_g() instanceof EntityLivingBase && AdventOfAscension.rand.nextInt(15) == 0) {
                    plData.enableRevenge((EntityLivingBase)ev.getSource().func_76346_g());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent ev) {
        if (!ev.getEntityLiving().field_70170_p.field_72995_K) {
            if (ev.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer pl = (EntityPlayer)ev.getEntityLiving();
                PlayerUtil.getAdventPlayer(pl).handleIncomingDamage(ev);
                Entity creeper = ev.getSource().func_76364_f();
                if (pl.func_110143_aJ() > 0.0f && ev.getSource().func_94541_c() && creeper instanceof EntityCreeper && (!pl.field_70170_p.func_72872_a(EntityTNTPrimed.class, creeper.func_174813_aQ().func_186662_g(3.0)).isEmpty() || !pl.field_70170_p.func_72872_a(EntityTNTPrimed.class, pl.func_174813_aQ().func_186662_g(3.0)).isEmpty()) && ItemUtil.consumeItem(pl, new ItemStack((Item)ItemRegister.realmstoneBlank))) {
                    ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((Item)ItemRegister.realmstoneCreeponia));
                }
            } else if (ev.getSource().func_76346_g() instanceof EntityPlayer) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)ev.getSource().func_76346_g());
                plData.handleOutgoingDamage(ev);
                if (EntityUtil.isMeleeDamage(ev.getSource()) && !ev.getSource().func_151517_h()) {
                    ButcheryUtil.tryCritical(ev, plData);
                    if (AdventOfAscension.rand.nextInt(30) == 0) {
                        ev.getEntity().field_70170_p.func_72838_d((Entity)new EntityBloodlust(ev.getEntity().field_70170_p, ev.getEntity().func_180425_c()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent ev) {
        if (!ev.getEntity().field_70170_p.field_72995_K && ev.getEntity() instanceof EntityPlayer) {
            if (ev.getDistance() > 25.0f && ev.getDamageMultiplier() > 0.0f && ItemUtil.consumeItem((EntityPlayer)ev.getEntity(), new ItemStack((Item)ItemRegister.realmstoneBlank))) {
                ItemUtil.givePlayerItemOrDrop((EntityPlayer)ev.getEntity(), new ItemStack((Item)ItemRegister.realmstoneLelyetia));
            }
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)ev.getEntity());
            plData.handlePlayerFalling(ev);
            ExpeditionUtil.handleFallEvent(ev, plData);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDeath(LivingDeathEvent ev) {
        if (!ev.getEntity().field_70170_p.field_72995_K) {
            if (ev.getEntity() instanceof EntityPlayer) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)ev.getEntity());
                plData.stats().resetAllTribute();
                plData.handlePlayerDeath(ev);
                ReservedItem.handlePlayerDeath(plData.player());
                if (!ev.getEntity().field_70128_L && ev.getSource().func_76346_g() instanceof EntityLivingBase) {
                    ev.getSource().func_76346_g().func_70074_a((EntityLivingBase)ev.getEntity());
                }
            } else if (ev.getSource().func_76346_g() instanceof EntityPlayer) {
                ItemStack blankRealmstoneStack;
                if (ev.getEntity().field_70170_p.field_73011_w.getDimension() == 0) {
                    if (ev.getEntity().field_70170_p.func_72935_r()) {
                        PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)ev.getSource().func_76346_g());
                        plData.stats().addTribute(Enums.Deities.EREBON, 8);
                        plData.stats().addTribute(Enums.Deities.LUXON, -8);
                    }
                } else if (ev.getEntity().field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.crystevia && ev.getEntity().getClass().toString().contains("Construct") && (blankRealmstoneStack = ItemUtil.getStackFromInventory((EntityPlayer)ev.getSource().func_76346_g(), ItemRegister.realmstoneBlank)) != null) {
                    BlankRealmstone.handleAncientCavernTask(blankRealmstoneStack, ev.getEntityLiving(), (EntityPlayer)ev.getSource().func_76346_g());
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerChangeEquipment(LivingEquipmentChangeEvent ev) {
        if (!ev.getEntityLiving().field_70170_p.field_72995_K && ev.getEntityLiving() instanceof EntityPlayer) {
            PlayerUtil.getAdventPlayer((EntityPlayer)ev.getEntityLiving()).equipment().markDirty();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        if (!ev.player.field_70170_p.field_72995_K) {
            PlayerUtil.getAdventPlayer(ev.player).handlePlayerRespawn(ev);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone ev) {
        if (!ev.getEntityPlayer().field_70170_p.field_72995_K) {
            PlayerUtil.clonePlayerData(ev.getOriginal(), ev.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onWorldChange(PlayerEvent.PlayerChangedDimensionEvent ev) {
        if (!ev.player.field_70170_p.field_72995_K) {
            PlayerUtil.getAdventPlayer(ev.player).stats().resetAllTribute();
        }
        if (ev.fromDim == ConfigurationUtil.MainConfig.dimensionIds.lelyetia) {
            ev.player.func_189654_d(false);
        }
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent ev) {
        if (ev.getHarvester() == null || ev.getHarvester() instanceof FakePlayer) {
            return;
        }
        EntityPlayer pl = ev.getHarvester();
        Item tool = pl.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
        if (tool instanceof SpecialHarvestTool) {
            ((SpecialHarvestTool)tool).doHarvestEffect(ev);
        }
        if (ev.getWorld().field_72995_K) {
            return;
        }
        Block bl = ev.getState().func_177230_c();
        if (bl instanceof BlockCrops || bl instanceof BlockFlower || bl instanceof BlockVine || bl instanceof BlockLeaves) {
            if (!(bl instanceof BlockCrops) || ((BlockCrops)bl).func_185525_y(ev.getState())) {
                if (bl instanceof BlockCrops) {
                    PlayerUtil.getAdventPlayer(pl).stats().addTribute(Enums.Deities.SELYAN, 2);
                    if (AdventOfAscension.rand.nextInt(2000) == 0) {
                        pl.func_70099_a(new ItemStack((Item)WeaponRegister.gunGardener), 0.0f);
                    }
                }
                if (bl instanceof BlockLeaves ? AdventOfAscension.rand.nextInt(35) == 0 : (bl instanceof BlockCrops ? AdventOfAscension.rand.nextInt(6) == 0 : AdventOfAscension.rand.nextInt(8) == 0)) {
                    EntityAnimaStone animaStone = new EntityAnimaStone(ev.getWorld(), ev.getPos());
                    ev.getWorld().func_184133_a(null, ev.getPos(), SoundsRegister.heartStoneSpawn, SoundCategory.MASTER, 1.0f, 1.0f);
                    ev.getWorld().func_72838_d((Entity)animaStone);
                }
            }
        } else if (bl == Blocks.field_150348_b || bl == Blocks.field_150424_aL || bl instanceof StoneBlock || bl == Blocks.field_150377_bs) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            int lvl = plData.stats().getLevel(Enums.Skills.FORAGING);
            if ((bl != Blocks.field_150424_aL || AdventOfAscension.rand.nextBoolean()) && ForagingUtil.shouldGetLoot(lvl)) {
                ev.getDrops().addAll(ForagingUtil.getLoot(pl));
                if (plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.FORAGING) {
                    ev.getDrops().addAll(ForagingUtil.getLoot(pl));
                }
                ev.getWorld().func_184133_a(null, ev.getPos(), SoundsRegister.foragingLoot, SoundCategory.MASTER, 1.0f, 1.0f);
                if (ev.getWorld().field_73011_w.getDimension() == 0) {
                    plData.stats().addTribute(Enums.Deities.PLUTON, 11 - lvl / 10);
                }
            }
        } else if (bl instanceof BlockLog) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            int lvl = plData.stats().getLevel(Enums.Skills.LOGGING);
            if (LoggingUtil.shouldGetLoot(lvl)) {
                if (AdventOfAscension.rand.nextBoolean()) {
                    ev.getDrops().addAll(LoggingUtil.getLoot(pl));
                    if (plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.LOGGING) {
                        ev.getDrops().addAll(LoggingUtil.getLoot(pl));
                    }
                } else {
                    ItemStack duplicateStack = ItemStack.field_190927_a;
                    for (ItemStack stack : ev.getDrops()) {
                        if (stack.func_77973_b() != Item.func_150898_a((Block)bl)) continue;
                        duplicateStack = stack.func_77946_l();
                        duplicateStack.func_190920_e(lvl > 50 ? 2 : 1);
                        plData.stats().addXp(Enums.Skills.LOGGING, (float)Math.pow(lvl, 1.65) * 3.0f, false, false);
                        break;
                    }
                    if (!duplicateStack.func_190926_b()) {
                        ev.getDrops().add(duplicateStack);
                    }
                }
                if (ev.getWorld().field_73011_w.getDimension() == 0) {
                    plData.stats().addTribute(Enums.Deities.PLUTON, 11 - lvl / 10);
                }
                ev.getWorld().func_184133_a(null, ev.getPos(), SoundsRegister.foragingLoot, SoundCategory.MASTER, 1.0f, 1.0f);
            }
        } else if (WorldUtil.isOreBlock(bl) && ev.getPos().func_177956_o() <= 5 && ItemUtil.consumeItem(pl, new ItemStack((Item)ItemRegister.realmstoneBlank))) {
            ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((Item)ItemRegister.realmstoneDeeplands));
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent ev) {
        if (!ev.getPlayer().field_71075_bZ.field_75098_d && !ev.getWorld().func_175660_a(ev.getPlayer(), ev.getPos())) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent ev) {
        if (!ev.getPlayer().field_71075_bZ.field_75098_d && ev.getWorld().field_73011_w instanceof AoAWorldProvider && !((AoAWorldProvider)ev.getWorld().field_73011_w).canPlaceBlock(ev.getPlayer(), ev.getPos(), ev.getPlacedBlock())) {
            ev.setCanceled(true);
            return;
        }
        if (!ev.getWorld().field_72995_K && PlayerUtil.isWearingFullSet(ev.getPlayer(), Enums.ArmourSets.HYDRANGIC) && ev.getPlacedBlock().func_177230_c() instanceof IGrowable && ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (World)ev.getWorld(), (BlockPos)ev.getPos())) {
            ev.getWorld().func_175718_b(2005, ev.getPos(), 0);
            ev.getPlayer().field_71071_by.func_70449_g(4.0f);
        }
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock ev) {
        if (!ev.getEntityPlayer().field_71075_bZ.field_75098_d && ev.getWorld().field_73011_w instanceof AoAWorldProvider && !((AoAWorldProvider)ev.getWorld().field_73011_w).canInteractWith(ev.getEntityPlayer(), ev.getPos(), null, ev.getItemStack())) {
            ev.setCancellationResult(EnumActionResult.SUCCESS);
            ev.setUseItem(Event.Result.DENY);
            ev.setResult(Event.Result.DENY);
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEmptyBucketUse(FillBucketEvent ev) {
        if (!ev.getEntityPlayer().field_71075_bZ.field_75098_d && ev.getWorld().field_73011_w instanceof AoAWorldProvider && !((AoAWorldProvider)ev.getWorld().field_73011_w).canInteractWith(ev.getEntityPlayer(), ev.getTarget() == null ? null : ev.getTarget().func_178782_a(), null, ev.getEmptyBucket())) {
            ev.setCanceled(true);
            ev.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPlayerWakeup(PlayerWakeUpEvent ev) {
        EntityPlayer pl = ev.getEntityPlayer();
        if (!pl.field_70170_p.field_72995_K && pl.field_70170_p.field_73011_w.getDimension() == 0) {
            PlayerUtil.getAdventPlayer(pl).stats().resetAllTribute();
            if (pl.field_70170_p instanceof WorldServer) {
                OverworldEvents.doWorldStartCheck(pl.field_70170_p);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (ev.player instanceof EntityPlayerMP && !ev.player.field_70170_p.field_72995_K) {
            UUID uuid = ev.player.func_146103_bH().getId();
            String msg = null;
            if (AdventOfAscension.instance().isTslat(uuid)) {
                msg = TextFormatting.DARK_RED + "It begins...Is this the end?";
                ((WorldServer)ev.player.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, ev.player.field_70165_t, ev.player.field_70163_u + 0.2, ev.player.field_70161_v, 16, 0.5, 0.5, 0.5, 0.1, new int[0]);
            } else if (uuid.equals(UUID.fromString("010318ef-28fc-4c7c-8940-2f0d62eabfa6"))) {
                msg = TextFormatting.LIGHT_PURPLE + "Xolova creeps in to watch you suffer. Feel free to die now.";
            } else if (PlayerCrownHandler.isCrazyDonator(uuid)) {
                msg = TextFormatting.LIGHT_PURPLE + "They approach. Tremble before them.";
            }
            if (msg != null) {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(msg));
            }
            OverworldEvents.alertNewPlayer(ev.player.field_70170_p, ev.player);
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(ev.player);
            PlayerDataManager.PlayerStats stats = plData.stats();
            for (Enums.Skills sk : Enums.Skills.values()) {
                PacketUtil.network.sendTo((IMessage)new PacketSkillData(sk.id, stats.getLevelForDisplay(sk), stats.getExp(sk), stats.getSkillData(Enums.Skills.EXPEDITION)), (EntityPlayerMP)ev.player);
            }
            EntityUtil.applyAttributeModifierSafely((EntityLivingBase)ev.player, SharedMonsterAttributes.field_111267_a, AoAAttributes.innervationHealthBuff(InnervationUtil.getHealthBuff(stats.getLevel(Enums.Skills.INNERVATION))));
            PacketUtil.network.sendTo((IMessage)new PacketTributeData(stats.getTribute(Enums.Deities.EREBON), stats.getTribute(Enums.Deities.LUXON), stats.getTribute(Enums.Deities.PLUTON), stats.getTribute(Enums.Deities.SELYAN)), (EntityPlayerMP)ev.player);
            PacketUtil.network.sendTo((IMessage)new PacketResourceData(stats.getResourceValue(Enums.Resources.CREATION), stats.getResourceValue(Enums.Resources.ENERGY), stats.getResourceValue(Enums.Resources.RAGE), stats.getResourceValue(Enums.Resources.SOUL), plData.isRevengeActive()), (EntityPlayerMP)ev.player);
            PlayerCrownHandler.syncWithNewClient((EntityPlayerMP)ev.player);
            PlayerAdvancements plAdvancements = ((EntityPlayerMP)ev.player).func_192039_O();
            Advancement rootAdv = ModUtil.getAdvancement("overworld/root");
            if (rootAdv == null) {
                AdventOfAscension.logMessage(Level.WARN, "Unable to find inbuilt advancements, another mod is breaking things.");
                if (ConfigurationUtil.MainConfig.doVerboseDebugging) {
                    AdventOfAscension.logOptionalMessage("Printing out current advancements list...");
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_191949_aK().func_192780_b().forEach(advancement -> AdventOfAscension.logOptionalMessage(advancement.func_192067_g().toString()));
                }
            }
            if (!plAdvancements.func_192747_a(rootAdv).func_192105_a()) {
                plAdvancements.func_192750_a(ModUtil.getAdvancement("overworld/by_the_books"), "legitimate");
                plAdvancements.func_192750_a(rootAdv, "playerjoin");
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent ev) {
        World world = ev.getPlayer().func_130014_f_();
        if (!world.field_72995_K) {
            EntityItem entityItem = ev.getEntityItem();
            Item item = entityItem.func_92059_d().func_77973_b();
            if (item == ItemRegister.realmstoneBlank) {
                if (entityItem.func_180799_ab()) {
                    ItemUtil.givePlayerItemOrDrop(ev.getPlayer(), new ItemStack((Item)ItemRegister.realmstoneNether));
                }
            } else if (item instanceof BossSpawningItem) {
                if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                    PlayerUtil.getAdventPlayer(ev.getPlayer()).sendThrottledChatMessage("message.feedback.spawnBoss.difficultyFail", new Object[0]);
                    return;
                }
                ev.setCanceled(true);
                world.func_72838_d((Entity)EntityUtil.newBossEntityItemFromExisting(entityItem, ev.getPlayer()));
                BossSpawningItem bossItem = (BossSpawningItem)item;
                if (bossItem.getThrowingSound() != null) {
                    world.func_184148_a(null, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, bossItem.getThrowingSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPickupXp(PlayerPickupXpEvent ev) {
        EntityPlayer pl = ev.getEntityPlayer();
        if (!pl.field_70170_p.field_72995_K && ev.getOrb().field_70530_e > 0) {
            int i = ItemUtil.findItemInInventory(pl, ItemRegister.expFlask);
            if (i < 0) {
                return;
            }
            ItemStack stack = pl.field_71071_by.func_70301_a(i);
            ExpFlask.addExp((EntityPlayerMP)ev.getEntityPlayer(), i, stack, ev.getOrb().field_70530_e);
            ev.setCanceled(true);
            ev.getOrb().field_70530_e = 0;
            ev.getOrb().func_70106_y();
        }
    }

    @SubscribeEvent
    public void onPlayerFishing(ItemFishedEvent ev) {
        if (ev.getEntityPlayer().field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.lborean && ev.getEntityPlayer().func_70681_au().nextInt(10) == 0) {
            EntityFishHook hook = ev.getHookEntity();
            EntityPlayer pl = ev.getEntityPlayer();
            EntityItem drop = new EntityItem(pl.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, new ItemStack((Item)ItemRegister.callOfTheDrake));
            double velocityX = pl.field_70165_t - hook.field_70165_t;
            double velocityY = pl.field_70163_u - hook.field_70163_u;
            double velocityZ = pl.field_70161_v - hook.field_70161_v;
            double velocity = MathHelper.func_76133_a((double)(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ));
            drop.field_70159_w = velocityX * 0.1;
            drop.field_70181_x = velocityY * 0.1 + (double)MathHelper.func_76133_a((double)velocity) * 0.08;
            drop.field_70179_y = velocityZ * 0.1;
            pl.field_70170_p.func_72838_d((Entity)drop);
        }
    }
}

