/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.crafting.recipes.InfusionTableRecipe;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;

@SideOnly(value=Side.CLIENT)
public class InfusionRecipeWrapper
implements IRecipeWrapper {
    private final InfusionTableRecipe recipe;

    private InfusionRecipeWrapper(InfusionTableRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ArrayList> ingredientsCollection = new ArrayList<ArrayList>();
        ArrayList<ItemStack> inputStackList = new ArrayList<ItemStack>(1);
        ItemStack output = this.recipe.func_77571_b();
        if (this.recipe.isEnchanting()) {
            output = this.recipe.getEnchantmentAsBook();
        }
        inputStackList.add(this.recipe.getRecipeInput());
        ingredientsCollection.add(inputStackList);
        for (Ingredient ing : this.recipe.func_192400_c()) {
            ingredientsCollection.add(Lists.newArrayList((Object[])ing.func_193365_a()));
        }
        ingredients.setInputLists(VanillaTypes.ITEM, ingredientsCollection);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int posY;
        int posX;
        int width;
        int shadowColour;
        int textColour;
        String message;
        if (this.recipe == null) {
            return;
        }
        if (this.recipe.getInfusionReq() > 1) {
            message = StringUtil.getLocaleString("skills.infusion.name") + ": " + this.recipe.getInfusionReq();
            textColour = AdventGuiTabPlayer.getSkillLevel(Enums.Skills.INFUSION) < this.recipe.getInfusionReq() ? -40864 : -8323296;
            shadowColour = 0xFF000000 | (textColour & 0xFCFCFC) >> 2;
            width = minecraft.field_71466_p.func_78256_a(message);
            posX = recipeWidth - 4 - width;
            posY = 10;
            if (minecraft.field_71466_p.func_82883_a()) {
                Gui.func_73734_a((int)(posX - 2), (int)(posY - 2), (int)(posX + width + 2), (int)(posY + 10), (int)-16777216);
                Gui.func_73734_a((int)(posX - 1), (int)(posY - 1), (int)(posX + width + 1), (int)(posY + 9), (int)-12895429);
            } else {
                minecraft.field_71466_p.func_78276_b(message, posX + 1, posY, shadowColour);
                minecraft.field_71466_p.func_78276_b(message, posX, posY + 1, shadowColour);
                minecraft.field_71466_p.func_78276_b(message, posX + 1, posY + 1, shadowColour);
            }
            minecraft.field_71466_p.func_78276_b(message, posX, posY, textColour);
        }
        if (this.recipe.getMaxXp() > 0) {
            message = StringUtil.getLocaleStringWithArguments("gui.misc.skills.xp", String.valueOf(this.recipe.getMinXp() == this.recipe.getMaxXp() ? Integer.valueOf(this.recipe.getMaxXp()) : this.recipe.getMinXp() + "-" + this.recipe.getMaxXp()));
            textColour = -7368817;
            shadowColour = 0xFF000000 | (textColour & 0xFCFCFC) >> 2;
            width = minecraft.field_71466_p.func_78256_a(message);
            posX = recipeWidth - 8 - width;
            posY = 50;
            if (minecraft.field_71466_p.func_82883_a()) {
                Gui.func_73734_a((int)(posX - 2), (int)(posY - 2), (int)(posX + width + 2), (int)(posY + 10), (int)-16777216);
                Gui.func_73734_a((int)(posX - 1), (int)(posY - 1), (int)(posX + width + 1), (int)(posY + 9), (int)-12895429);
            } else {
                minecraft.field_71466_p.func_78276_b(message, posX + 1, posY, shadowColour);
                minecraft.field_71466_p.func_78276_b(message, posX, posY + 1, shadowColour);
                minecraft.field_71466_p.func_78276_b(message, posX + 1, posY + 1, shadowColour);
            }
            minecraft.field_71466_p.func_78276_b(message, posX, posY, textColour);
        }
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.getRegistryName();
    }

    public InfusionTableRecipe getRecipe() {
        return this.recipe;
    }

    public static class Factory
    implements IRecipeWrapperFactory<InfusionTableRecipe> {
        public IRecipeWrapper getRecipeWrapper(InfusionTableRecipe recipe) {
            return new InfusionRecipeWrapper(recipe);
        }
    }
}

