/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public abstract class AdventArmour
extends ItemArmor {
    public AdventArmour(ItemArmor.ArmorMaterial material, String name, String registryName, EntityEquipmentSlot slot) {
        super(material, 0, slot);
        this.func_77637_a(CreativeTabsRegister.armourTab);
        this.func_77655_b(name);
        this.setRegistryName("aoa3:" + registryName);
    }

    public abstract Enums.ArmourSets setType();

    public void onEquip(PlayerDataManager plData, @Nullable EntityEquipmentSlot slot) {
    }

    public void onUnequip(PlayerDataManager plData, @Nullable EntityEquipmentSlot slot) {
    }

    public void addBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EntityEquipmentSlot slot) {
    }

    public void removeBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EntityEquipmentSlot slot) {
    }

    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots) {
    }

    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingHurtEvent event) {
    }

    public void onPreAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingAttackEvent event) {
    }

    public void onAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingHurtEvent event) {
    }

    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingDamageEvent event) {
    }

    public void onPlayerLandingFall(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingFallEvent event) {
    }

    public void onPlayerDeath(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingDeathEvent event) {
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean isSetHelmet(AdventArmour helmet) {
        return this.setType() == helmet.setType() || helmet.setType() == Enums.ArmourSets.ALL;
    }

    protected String setEffectHeader() {
        return StringUtil.getColourLocaleString("items.description.armour.set", TextFormatting.GOLD);
    }

    protected String pieceEffectHeader() {
        return StringUtil.getColourLocaleString("items.description.armour.piece", TextFormatting.GRAY);
    }

    protected String anySetEffectHeader() {
        return StringUtil.getColourLocaleString("items.description.armour.anySet", TextFormatting.DARK_AQUA);
    }
}

