/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class BiogenicArmour
extends AdventArmour {
    public BiogenicArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_BIOGENIC, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.BIOGENIC;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots) {
        if (slots == null) {
            if (plData.player().func_70090_H()) {
                plData.player().func_70050_g(-10);
            }
            if (plData.player().func_70055_a(Material.field_151586_h)) {
                plData.player().func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0, true, false));
            } else {
                PotionEffect nightVision = plData.player().func_70660_b(MobEffects.field_76439_r);
                if (nightVision != null && nightVision.func_76459_b() <= 300) {
                    plData.player().func_184589_d(MobEffects.field_76439_r);
                }
            }
        }
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingDamageEvent event) {
        if (slots != null && EntityUtil.isMeleeDamage(event.getSource()) && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            ((EntityLivingBase)event.getSource().func_76346_g()).func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)event.getAmount() * 3 * slots.size(), slots.size() >= 2 ? 1 : 0, false, true));
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EntityEquipmentSlot slot) {
        PotionEffect nightVision;
        if (slot == null && (nightVision = plData.player().func_70660_b(MobEffects.field_76439_r)) != null && nightVision.func_76459_b() <= 300) {
            plData.player().func_184589_d(MobEffects.field_76439_r);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.BiogenicArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.BiogenicArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.BiogenicArmour.desc.3", Enums.ItemDescriptionType.POSITIVE));
    }
}

