/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.SkillItem;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class LoggingArmour
extends AdventArmour
implements SkillItem {
    public LoggingArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_LOGGING, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.LOGGING;
    }

    @Override
    public Enums.Skills getSkill() {
        return Enums.Skills.LOGGING;
    }

    @Override
    public int getLevelReq() {
        return 100;
    }

    @Override
    public void addBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EntityEquipmentSlot slot) {
        if (slot == null) {
            plBuffs.addXpModifier(Enums.Skills.LOGGING, 0.3f);
        }
    }

    @Override
    public void removeBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EntityEquipmentSlot slot) {
        if (slot == null) {
            plBuffs.removeXpModifier(Enums.Skills.LOGGING, 0.3f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.LoggingArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.skillXpBonus", Enums.ItemDescriptionType.POSITIVE, Integer.toString(30), StringUtil.getLocaleString("skills.logging.name")));
        tooltip.add(ItemUtil.getFormattedLevelRestrictedDescriptionText(Enums.Skills.LOGGING, 100));
    }
}

