/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class LyonicArmour
extends AdventArmour {
    public LyonicArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_LYONIC, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.LYONIC;
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingHurtEvent event) {
        if (slots != null) {
            EntityItem item;
            EntityPlayer pl = plData.player();
            float range = 1.5f * (float)slots.size();
            Iterator iterator = plData.player().field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(pl.field_70165_t - (double)range, pl.field_70163_u - (double)range, pl.field_70161_v - (double)range, pl.field_70165_t + (double)range, pl.field_70163_u + (double)range, pl.field_70161_v + (double)range)).iterator();
            for (int pulledCount = 0; iterator.hasNext() && pulledCount <= 200 && this.canPullItem(item = (EntityItem)iterator.next()); ++pulledCount) {
                EntityUtil.pullEntityIn((Entity)pl, (Entity)item, 0.1f);
            }
        } else {
            EntityPlayer pl = plData.player();
            Iterator iterator = plData.player().field_70170_p.func_72872_a(EntityXPOrb.class, new AxisAlignedBB(pl.field_70165_t - 6.0, pl.field_70163_u - 6.0, pl.field_70161_v - 6.0, pl.field_70165_t + 6.0, pl.field_70163_u + 6.0, pl.field_70161_v + 6.0)).iterator();
            for (int pulledCount = 0; iterator.hasNext() && pulledCount <= 200; ++pulledCount) {
                EntityUtil.pullEntityIn((Entity)pl, (Entity)iterator.next(), 0.1f);
            }
        }
    }

    private boolean canPullItem(EntityItem item) {
        return !item.field_70128_L && !item.func_92059_d().func_190926_b() && !item.func_174874_s();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.LyonicArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.LyonicArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.LyonicArmour.desc.3", Enums.ItemDescriptionType.POSITIVE));
    }
}

