/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class NecroArmour
extends AdventArmour {
    public NecroArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_NECRO, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.NECRO;
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots) {
        super.onEffectTick(plData, slots);
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingDamageEvent event) {
        if (slots == null && !EntityUtil.isEnvironmentalDamage(event.getSource()) && event.getAmount() > plData.player().func_110143_aJ() && plData.equipment().isCooledDown(Enums.Counters.NECRO)) {
            EntityPlayer pl = plData.player();
            event.setAmount(0.0f);
            plData.equipment().setCooldown(Enums.Counters.NECRO, 72000);
            pl.field_71071_by.func_70449_g(500.0f);
            if (pl.func_110143_aJ() < 4.0f) {
                pl.func_70606_j(4.0f);
            }
            ((WorldServer)pl.field_70170_p).func_175739_a(EnumParticleTypes.HEART, pl.field_70165_t, pl.func_174813_aQ().field_72337_e, pl.field_70161_v, 5, 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void onPlayerDeath(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingDeathEvent event) {
        if (slots != null) {
            int count = slots.size();
            InventoryPlayer inv = plData.player().field_71071_by;
            for (int inventoryIndex = 0; count > 0 && inventoryIndex < inv.func_70302_i_(); ++inventoryIndex) {
                ItemStack stack = inv.func_70301_a(inventoryIndex);
                if (stack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.intervention, (ItemStack)stack) != 0) continue;
                plData.storeInterventionItem(stack);
                inv.func_70299_a(inventoryIndex, ItemStack.field_190927_a);
                --count;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.NecroArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.NecroArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.NecroArmour.desc.3", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.NecroArmour.desc.4", Enums.ItemDescriptionType.POSITIVE));
    }
}

