/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.entity.boss.corallus.EntityCorallus;
import net.tslat.aoa3.item.misc.summon.BossSpawningItem;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class AmphibiyteLung
extends BossSpawningItem {
    public AmphibiyteLung() {
        super("AmphibiyteLung", "amphibiyte_lung", null, EnumParticleTypes.WATER_BUBBLE);
    }

    @Override
    public void handleTimerParticles(EntityItem entityItem, double posX, double posY, double posZ, int lifespan, int ticksExisted) {
        if (entityItem.func_70090_H() && entityItem.func_92059_d().func_190916_E() == 5) {
            super.handleTimerParticles(entityItem, posX, posY, posZ, lifespan, ticksExisted);
        } else if (entityItem.func_92059_d().func_190916_E() != 5 || entityItem.field_70173_aa > 40 && lifespan != 200) {
            entityItem.lifespan = 6000;
        }
    }

    @Override
    public void spawnBoss(World world, EntityPlayer summoner, double posX, double posY, double posZ) {
        EntityCorallus corallus = new EntityCorallus(world);
        corallus.func_70012_b(posX, posY, posZ, field_77697_d.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)corallus);
        StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.corallus.spawn", summoner.getDisplayNameString()), (Entity)corallus, 50);
    }

    @Override
    public boolean canSpawnHere(World world, EntityPlayer player, double posX, double posY, double posZ) {
        if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != Blocks.field_150355_j) {
            return false;
        }
        if (world.func_184143_b(new AxisAlignedBB(posX - 0.5, posY, posZ - 0.5, posX + 0.5, posY + 3.0, posZ + 0.5))) {
            PlayerUtil.getAdventPlayer(player).sendThrottledChatMessage("message.feedback.spawnBoss.noSpace", new Object[0]);
            return false;
        }
        return true;
    }
}

