/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.entity.mobs.overworld.fullmoon.EntityDarkBeast;
import net.tslat.aoa3.entity.mobs.overworld.fullmoon.EntityIrkling;
import net.tslat.aoa3.entity.mobs.overworld.fullmoon.EntityNightWatcher;
import net.tslat.aoa3.entity.mobs.overworld.fullmoon.EntityScrubby;
import net.tslat.aoa3.entity.mobs.overworld.fullmoon.EntitySkellox;
import net.tslat.aoa3.entity.mobs.shyrelands.EntityArcworm;
import net.tslat.aoa3.item.misc.SimpleItem;
import net.tslat.aoa3.item.weapon.blaster.ExperimentW801;
import net.tslat.aoa3.utils.ItemUtil;

public class ReservedItem
extends SimpleItem {
    private final String sequenceId;

    public ReservedItem(String name, String registryName, String sequenceName) {
        super(name, registryName);
        this.func_77637_a(null);
        this.sequenceId = sequenceName;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.verifyStack(stack)) {
            stack.func_190920_e(0);
            entityIn.func_174820_d(itemSlot, ItemStack.field_190927_a);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == BlockRegister.chargingTable) {
            if (this == ItemRegister.fleshyBones) {
                player.func_184611_a(hand, ItemRegister.darkBones.newValidStack());
                return EnumActionResult.SUCCESS;
            }
        } else if (block == BlockRegister.mineralizationStation && this == ItemRegister.darkBones) {
            player.func_184611_a(hand, ItemRegister.rockBones.newValidStack());
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!target.field_70170_p.field_72995_K) {
            if (stack.func_77973_b() == ItemRegister.millenniumUpgrader) {
                if (target.func_180799_ab() && attacker.func_180799_ab()) {
                    attacker.func_184611_a(EnumHand.MAIN_HAND, ItemRegister.moltenUpgrader.newValidStack());
                    return true;
                }
            } else if (stack.func_77973_b() == ItemRegister.moltenUpgrader) {
                if (target.field_70170_p.func_130001_d() == 1.0f && target.func_110143_aJ() <= 0.0f && (target instanceof EntityDarkBeast || target instanceof EntityIrkling || target instanceof EntityNightWatcher || target instanceof EntityScrubby || target instanceof EntitySkellox)) {
                    attacker.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    target.func_70099_a(ItemRegister.moonstone.newValidStack(), 0.0f);
                    return true;
                }
            } else if (stack.func_77973_b() == ItemRegister.moonstone) {
                if (target instanceof EntityArcworm) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200, 10, true, false));
                }
                return true;
            }
        }
        return false;
    }

    public boolean onEntityItemUpdate(EntityItem entity) {
        if (!this.verifyStack(entity.func_92059_d())) {
            entity.func_92058_a(ItemStack.field_190927_a);
            entity.func_70106_y();
        }
        return false;
    }

    public ItemStack newValidStack() {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(this.sequenceId, true);
        stack.func_77982_d(tag);
        return stack;
    }

    private boolean verifyStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b(this.sequenceId)) {
            return false;
        }
        return tag.func_74767_n(this.sequenceId);
    }

    public static void handleArcworm(EntityArcworm arcworm) {
        if (arcworm.field_70163_u > 275.0 && arcworm.func_94060_bK() instanceof EntityPlayer && arcworm.func_94060_bK().func_184614_ca().func_77973_b() == ItemRegister.moonstone) {
            arcworm.func_70099_a(((ExperimentW801)WeaponRegister.blasterExperimentW801).newValidStack(), 0.0f);
            arcworm.func_94060_bK().func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            arcworm.func_70106_y();
        }
    }

    public static void handlePlayerDeath(EntityPlayer pl) {
        if (pl.func_110143_aJ() > 0.0f) {
            return;
        }
        if (!pl.func_184614_ca().func_77973_b().getRegistryName().func_110623_a().toLowerCase().startsWith("a")) {
            return;
        }
        NonNullList armour = pl.field_71071_by.field_70460_b;
        if (!((ItemStack)armour.get(3)).func_77973_b().getRegistryName().func_110623_a().toLowerCase().startsWith("l")) {
            return;
        }
        if (!((ItemStack)armour.get(2)).func_77973_b().getRegistryName().func_110623_a().toLowerCase().startsWith("i")) {
            return;
        }
        if (!((ItemStack)armour.get(1)).func_77973_b().getRegistryName().func_110623_a().toLowerCase().startsWith("e")) {
            return;
        }
        if (!((ItemStack)armour.get(0)).func_77973_b().getRegistryName().func_110623_a().toLowerCase().startsWith("n")) {
            return;
        }
        if (ItemUtil.findItemInInventory(pl, ItemRegister.alienOrb) != -1) {
            return;
        }
        pl.func_70099_a(ItemRegister.alienOrb.newValidStack(), 0.0f);
    }
}

