/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.blaster.EntitySoulSpark;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class SoulSpark
extends BaseBlaster {
    public SoulSpark(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
        this.func_77655_b("SoulSpark");
        this.setRegistryName("aoa3:soul_spark");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunSoulSpark;
    }

    @Override
    public void fire(ItemStack blaster, EntityLivingBase shooter) {
        shooter.field_70170_p.func_72838_d((Entity)new EntitySoulSpark(shooter, this, 5));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (!EntityUtil.isSpecExempt(target, shooter) && !EntityUtil.isTypeImmune(target, Enums.MobProperties.BLASTER_IMMUNE)) {
            if (shooter instanceof EntityPlayerMP && !((EntityPlayerMP)shooter).field_71075_bZ.field_75098_d) {
                EntityPlayer player = (EntityPlayer)shooter;
                PlayerDataManager.PlayerStats stats = PlayerUtil.getAdventPlayer(player).stats();
                if (stats.getResourceValue(Enums.Resources.ENERGY) < 200.0f) {
                    PlayerUtil.notifyPlayerOfInsufficientResources((EntityPlayerMP)player, Enums.Resources.ENERGY, 200.0f);
                    return false;
                }
                if (stats.getResourceValue(Enums.Resources.SOUL) < 50.0f) {
                    PlayerUtil.notifyPlayerOfInsufficientResources((EntityPlayerMP)player, Enums.Resources.SOUL, 50.0f);
                    return false;
                }
                stats.consumeResource(Enums.Resources.ENERGY, 200.0f, false);
                stats.consumeResource(Enums.Resources.SOUL, 50.0f, false);
                EnumHand hand = player.func_184600_cs();
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() != this) {
                    stack = player.func_184586_b(hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
                }
                if (stack.func_77973_b() != this) {
                    return false;
                }
                stack.func_77972_a(1, shooter);
            }
            target.func_70106_y();
            return true;
        }
        return false;
    }

    @Override
    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (!player.field_70170_p.field_72995_K) {
            float energyConsumption;
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)player);
            int recharge = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.recharge, (ItemStack)stack);
            int greed = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.greed, (ItemStack)stack);
            float f = energyConsumption = ((EntityPlayer)player).field_71075_bZ.field_75098_d ? 0.0f : (1.0f + 0.3f * (float)greed) * this.energyCost * Math.max(0.0f, 1.0f - 0.07f * (float)recharge);
            if (plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.GHOULISH) {
                energyConsumption *= 0.7f;
            }
            if (plData.stats().getResourceValue(Enums.Resources.ENERGY) >= energyConsumption) {
                if (count + this.firingDelay <= 72000 && count % this.firingDelay == 0) {
                    if (this.consumeEnergy(plData, stack, energyConsumption)) {
                        if (this.getFiringSound() != null) {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        this.fire(stack, player);
                        ((EntityPlayer)player).func_71029_a(StatList.func_188057_b((Item)this));
                    } else {
                        player.func_184597_cx();
                    }
                }
            } else {
                if (player instanceof EntityPlayerMP) {
                    PlayerUtil.notifyPlayerOfInsufficientResources((EntityPlayerMP)player, Enums.Resources.ENERGY, energyConsumption);
                }
                player.func_184597_cx();
            }
        }
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int useTicksRemaining) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SoulSpark.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.damage.specImmune", Enums.ItemDescriptionType.NEGATIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.resource", Enums.ItemDescriptionType.ITEM_AMMO_COST, "50", StringUtil.getLocaleString("resources.soul.name")));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.blaster.fire", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.blaster.slowing", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.blaster.effect", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
    }
}

