/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class VortexBlaster
extends BaseBlaster {
    public VortexBlaster(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
        this.func_77655_b("VortexBlaster");
        this.setRegistryName("aoa3:vortex_blaster");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunGravityBlaster;
    }

    @Override
    public void fire(ItemStack blaster, EntityLivingBase shooter) {
        float x = -MathHelper.func_76126_a((float)(shooter.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(shooter.field_70125_A / 180.0f * (float)Math.PI));
        float y = -MathHelper.func_76126_a((float)(shooter.field_70125_A / 180.0f * (float)Math.PI));
        float z = MathHelper.func_76134_b((float)(shooter.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(shooter.field_70125_A / 180.0f * (float)Math.PI));
        for (EntityLivingBase entity2 : shooter.field_70170_p.func_175647_a(EntityLivingBase.class, shooter.func_174813_aQ().func_72314_b((double)(x * 7.0f + 1.0f), (double)(y * 7.0f + 1.0f), (double)(z * 7.0f + 1.0f)), entity -> !EntityUtil.isTypeImmune((Entity)entity, Enums.MobProperties.BLASTER_IMMUNE))) {
            EntityUtil.doScaledKnockback(entity2, (Entity)shooter, 4.0f, shooter.field_70165_t - entity2.field_70165_t, shooter.field_70161_v - entity2.field_70161_v);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.VortexBlaster.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

