/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.blaster.EntityWinderShot;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PredicateUtil;

public class WhimsyWinder
extends BaseBlaster {
    public WhimsyWinder(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
        this.func_77655_b("WhimsyWinder");
        this.setRegistryName("aoa3:whimsy_winder");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunWhimsyWinder;
    }

    @Override
    public void fire(ItemStack blaster, EntityLivingBase shooter) {
        shooter.field_70170_p.func_72838_d((Entity)new EntityWinderShot(shooter, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        List nearbyTargets = shot.field_70170_p.func_72839_b(target, target.func_174813_aQ().func_72314_b(3.0, 1.0, 3.0));
        nearbyTargets.removeIf(entity -> !(entity instanceof EntityLivingBase) || !PredicateUtil.IS_HOSTILE_MOB.apply((Object)((EntityLivingBase)entity)));
        nearbyTargets.add(target);
        float splitDmg = (float)(this.baseDmg / (double)nearbyTargets.size() * Math.pow(1.05, nearbyTargets.size()));
        boolean success = false;
        for (Entity entity2 : nearbyTargets) {
            success |= EntityUtil.dealBlasterDamage(shooter, entity2, (Entity)shot, splitDmg, false);
        }
        return success;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.WhimsyWinder.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

