/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.bow;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.item.misc.HollyArrow;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.utils.StringUtil;

public abstract class BaseBow
extends ItemBow
implements AdventWeapon {
    protected float drawSpeedMultiplier;
    protected double dmg;

    public BaseBow(double damage, float drawSpeedMultiplier, int durability) {
        this.dmg = damage;
        this.drawSpeedMultiplier = drawSpeedMultiplier;
        this.func_77656_e(durability);
        this.func_77625_d(1);
        this.func_77664_n();
        this.setNoRepair();
        this.func_77637_a(CreativeTabsRegister.bowsTab);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                return !(entity.func_184607_cu().func_77973_b() instanceof BaseBow) ? 0.0f : BaseBow.this.getDrawSpeedMultiplier() * (float)(BaseBow.this.func_77626_a(stack) - entity.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public double getDamage() {
        return this.dmg;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase shooter, int timeLeft) {
        if (!(shooter instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer pl = (EntityPlayer)shooter;
        boolean infiniteAmmo = pl.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack ammoStack = this.func_185060_a(pl);
        int charge = (int)((float)(this.func_77626_a(stack) - timeLeft) * this.getDrawSpeedMultiplier());
        if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)pl, (int)charge, (!ammoStack.func_190926_b() || infiniteAmmo ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (!ammoStack.func_190926_b() || infiniteAmmo) {
            float velocity;
            if (ammoStack.func_190926_b()) {
                ammoStack = new ItemStack((Item)ItemRegister.hollyArrow);
            }
            if ((double)(velocity = BaseBow.getArrowVelocity(charge)) >= 0.1) {
                if (!world.field_72995_K) {
                    EntityHollyArrow arrow = this.makeArrow((EntityLivingBase)pl, stack, ammoStack, velocity, !infiniteAmmo);
                    this.doArrowMods(arrow, shooter, timeLeft);
                    world.func_72838_d((Entity)arrow);
                }
                world.func_184148_a(null, pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
            }
        }
    }

    protected EntityHollyArrow makeArrow(EntityLivingBase shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        HollyArrow arrowItem = ammoStack.func_77973_b() instanceof HollyArrow ? ammoStack.func_77973_b() : ItemRegister.hollyArrow;
        EntityHollyArrow arrowEntity = arrowItem.createArrow(shooter.field_70170_p, this, ammoStack, shooter, this.dmg);
        arrowEntity.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
        int powerEnchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bowStack);
        int punchEnchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bowStack);
        if (velocity >= 1.0f) {
            arrowEntity.func_70243_d(true);
        }
        if (powerEnchant > 0) {
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)powerEnchant * 1.5 + 1.0);
        }
        if (punchEnchant > 0) {
            arrowEntity.func_70240_a(punchEnchant);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bowStack) > 0) {
            arrowEntity.func_70015_d(100);
        }
        if (!consumeAmmo || shooter instanceof EntityPlayer && ((EntityPlayer)shooter).field_71075_bZ.field_75098_d && (ammoStack.func_77973_b() == Items.field_185166_h || ammoStack.func_77973_b() == Items.field_185167_i)) {
            arrowEntity.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        }
        bowStack.func_77972_a(1, shooter);
        if (shooter instanceof EntityPlayer && consumeAmmo) {
            ammoStack.func_190918_g(1);
            if (ammoStack.func_190926_b()) {
                ((EntityPlayer)shooter).field_71071_by.func_184437_d(ammoStack);
            }
        }
        return arrowEntity;
    }

    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean func_185058_h_(ItemStack stack) {
        return stack.func_77973_b() instanceof HollyArrow;
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public float getDrawSpeedMultiplier() {
        return this.drawSpeedMultiplier;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return OreDictionary.itemMatches((ItemStack)repairMaterial, (ItemStack)new ItemStack((Item)ItemRegister.magicRepairDust), (boolean)false) || super.func_82789_a(stack, repairMaterial);
    }

    public void doArrowMods(EntityHollyArrow arrow, EntityLivingBase shooter, int useTicksRemaining) {
    }

    public void doImpactEffect(EntityHollyArrow arrow, Entity target, Entity shooter, float damage) {
    }

    public void doBlockImpact(EntityHollyArrow arrow, IBlockState blockState, Entity shooter) {
    }

    public void doArrowTick(EntityHollyArrow arrow, Entity shooter) {
    }

    public float getArrowDamage(EntityHollyArrow arrow, Entity target, float currentDamage) {
        return currentDamage;
    }

    public int func_77619_b() {
        return 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.arrows", TextFormatting.DARK_RED, Double.toString(this.dmg)));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.bow.drawSpeed", Double.toString((double)((int)(72000.0f / this.getDrawSpeedMultiplier()) / 720) / 100.0)));
        tooltip.add(StringUtil.getColourLocaleString("items.description.ammo.arrows", TextFormatting.LIGHT_PURPLE));
    }
}

