/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.bow;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.item.weapon.bow.BaseBow;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class SoulfireBow
extends BaseBow {
    public SoulfireBow(double damage, float drawSpeedMultiplier, int durability) {
        super(damage, drawSpeedMultiplier, durability);
        this.func_77655_b("SoulfireBow");
        this.setRegistryName("aoa3:soulfire_bow");
    }

    @Override
    protected EntityHollyArrow makeArrow(EntityLivingBase shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        EntityHollyArrow arrow = super.makeArrow(shooter, bowStack, ammoStack, velocity, consumeAmmo);
        if (arrow != null && shooter instanceof EntityPlayer && PlayerUtil.consumeResource((EntityPlayer)shooter, Enums.Resources.SOUL, 50.0f, false)) {
            arrow.func_184195_f(true);
        }
        return arrow;
    }

    @Override
    public void doImpactEffect(EntityHollyArrow arrow, Entity target, Entity shooter, float damage) {
        if (arrow.func_184202_aL() && shooter instanceof EntityLivingBase && !shooter.field_70128_L) {
            ((EntityLivingBase)shooter).func_70691_i(8.0f);
        }
        arrow.func_184195_f(false);
    }

    @Override
    public void doBlockImpact(EntityHollyArrow arrow, IBlockState blockState, Entity shooter) {
        arrow.func_184195_f(false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SoulfireBow.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SoulfireBow.desc.2", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

