/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.greatblade;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class SelyanScythe
extends BaseGreatblade {
    public SelyanScythe(double dmg, double speed, int durability) {
        super(dmg, speed, durability);
        this.func_77655_b("SelyanScythe");
        this.setRegistryName("aoa3:selyan_scythe");
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, EntityLivingBase attacker, Entity target, float dmgDealt) {
        float damagePercent = Math.min(dmgDealt / (float)this.dmg, 1.0f);
        attacker.func_70691_i(1.0f * damagePercent);
        PlayerDataManager.PlayerStats targetStats = target instanceof EntityPlayerMP ? PlayerUtil.getAdventPlayer((EntityPlayer)target).stats() : null;
        float soulAmount = (targetStats != null ? Math.min(5.0f, targetStats.getResourceValue(Enums.Resources.SOUL)) : 5.0f) * damagePercent;
        if (soulAmount > 0.0f) {
            if (targetStats != null && !targetStats.consumeResource(Enums.Resources.SOUL, soulAmount, true)) {
                return;
            }
            if (attacker instanceof EntityPlayerMP) {
                PlayerUtil.addResourceToPlayer((EntityPlayer)attacker, Enums.Resources.SOUL, soulAmount);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SelyanScythe.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.scythe", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
    }
}

