/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public class FlamingFury
extends BaseGun {
    public FlamingFury(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.func_77655_b("FlamingFury");
        this.setRegistryName("aoa3:flaming_fury");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunFastRifle;
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, BaseGun gun, EnumHand hand) {
        BaseBullet bullet = super.findAndConsumeAmmo(player, gun, hand);
        if (bullet != null) {
            if (!player.field_70170_p.field_72995_K) {
                for (int i = 0; i < 6; ++i) {
                    ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.DRAGON_BREATH, bullet.field_70165_t + field_77697_d.nextGaussian() / 5.0, bullet.field_70163_u + field_77697_d.nextGaussian() / 5.0, bullet.field_70161_v + field_77697_d.nextGaussian() / 5.0, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            return bullet;
        }
        return null;
    }

    @Override
    protected void doImpactEffect(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(bullet.field_70170_p, (target.field_70165_t + bullet.field_70165_t) / 2.0, (target.field_70163_u + bullet.field_70163_u) / 2.0, (target.field_70161_v + bullet.field_70161_v) / 2.0);
        cloud.func_184481_a(shooter);
        cloud.func_184491_a(EnumParticleTypes.DRAGON_BREATH);
        cloud.func_184483_a(1.0f);
        cloud.func_184485_d(0);
        cloud.func_184486_b(20);
        cloud.func_184487_c((5.0f - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        cloud.func_184496_a(new PotionEffect(MobEffects.field_76433_i, 1, 0));
        bullet.field_70170_p.func_72838_d((Entity)cloud);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.FlamingFury.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

