/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntityShoeShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.StringUtil;

public class ShoeFlinger
extends BaseGun {
    double dmg;
    int firingDelay;

    public ShoeFlinger(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
        this.func_77655_b("ShoeFlinger");
        this.setRegistryName("aoa3:shoe_flinger");
        this.func_77637_a(null);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunFlinger;
    }

    @Override
    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            float shellMod = 1.0f;
            if (bullet.getHand() != null) {
                shellMod = (float)((double)shellMod + 0.1 * (double)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.shell, (ItemStack)shooter.func_184586_b(bullet.getHand())));
            }
            if (EntityUtil.dealGunDamage(target, shooter, bullet, (float)this.dmg * bulletDmgMultiplier * shellMod) && target instanceof EntityLivingBase) {
                EntityUtil.doScaledKnockback((EntityLivingBase)target, (Entity)shooter, 1.35f, shooter.field_70165_t - target.field_70165_t, shooter.field_70161_v - target.field_70161_v);
                if (shooter instanceof EntityPlayerMP && ((EntityLivingBase)target).func_110143_aJ() == 0.0f && (target instanceof BossEntity || !target.func_184222_aU())) {
                    ModUtil.completeAdvancement((EntityPlayerMP)shooter, "overworld/la_chancla", "boss_kill");
                }
            }
        }
        if (target instanceof EntityLivingBase) {
            // empty if block
        }
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, BaseGun gun, EnumHand hand) {
        Item ammo = ItemUtil.findAndConsumeSpecialBullet((EntityLivingBase)player, gun, true, (Item)Items.field_151021_T, player.func_184586_b(hand));
        if (ammo != null) {
            return new EntityShoeShot((EntityLivingBase)player, gun, hand, 120, 0);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.gun", TextFormatting.DARK_RED, Double.toString(this.dmg)));
        tooltip.add(StringUtil.getColourLocaleString("item.ShoeFlinger.desc.1", TextFormatting.DARK_AQUA));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.ammo.other", TextFormatting.LIGHT_PURPLE, StringUtil.getLocaleString("item.bootsCloth.name")));
    }
}

