/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.shotgun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntityDischargeShot;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.item.weapon.shotgun.BaseShotgun;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class DischargeShotgun
extends BaseShotgun {
    private int firingDelay;

    public DischargeShotgun(double dmg, int pellets, int durability, int fireDelayTicks, float knockbackFactor, float recoil) {
        super(dmg, pellets, durability, fireDelayTicks, knockbackFactor, recoil);
        this.firingDelay = fireDelayTicks;
        this.func_77655_b("DischargeShotgun");
        this.setRegistryName("aoa3:discharge_shotgun");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunDischargeGun;
    }

    @Override
    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            bullet.doImpactEffect();
        }
        WorldUtil.createExplosion((Entity)shooter, bullet.field_70170_p, (Entity)bullet, 2.5f);
    }

    @Override
    public void fireShotgun(EntityLivingBase shooter, EnumHand hand, float spreadFactor, int pellets) {
        for (int i = 0; i < pellets; ++i) {
            EntityDischargeShot pellet = new EntityDischargeShot(shooter, this, hand, 4, 1.0f, 0, (field_77697_d.nextFloat() - 0.5f) * spreadFactor, (field_77697_d.nextFloat() - 0.5f) * spreadFactor, (field_77697_d.nextFloat() - 0.5f) * spreadFactor);
            shooter.field_70170_p.func_72838_d((Entity)pellet);
        }
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, BaseGun gun, EnumHand hand) {
        Item ammo = ItemUtil.findAndConsumeSpecialBullet((EntityLivingBase)player, gun, true, ItemRegister.dischargeCapsule, player.func_184586_b(hand));
        if (ammo != null) {
            return new EntityDischargeShot((EntityLivingBase)player, gun, hand, 4, 0);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(StringUtil.getColourLocaleString("item.DischargeShotgun.desc.1", TextFormatting.DARK_GREEN));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.ammo.other", TextFormatting.LIGHT_PURPLE, StringUtil.getLocaleString("item.DischargeCapsule.name")));
    }
}

