/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sniper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public class Crystaneer
extends BaseSniper {
    private static final ArrayList<ItemStack> gemDrops = new ArrayList(5);
    private static boolean populated = false;

    public Crystaneer(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.func_77655_b("Crystaneer");
        this.setRegistryName("aoa3:crystaneer");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunSniper;
    }

    @Override
    public Enums.ScopeScreens getScreen() {
        return Enums.ScopeScreens.CRYSTAL;
    }

    @Override
    protected void doImpactEffect(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target instanceof EntityLivingBase && ((EntityLivingBase)target).func_110143_aJ() <= 0.0f && field_77697_d.nextInt(5) == 0) {
            if (!populated) {
                Crystaneer.populateGemDrops();
            }
            target.func_70099_a(gemDrops.get(gemDrops.size() - 1), 0.0f);
        }
    }

    private static void populateGemDrops() {
        gemDrops.add(new ItemStack(Items.field_151045_i));
        gemDrops.add(new ItemStack(Items.field_151166_bC));
        gemDrops.add(new ItemStack((Item)ItemRegister.gemSapphire));
        gemDrops.add(new ItemStack((Item)ItemRegister.gemJade));
        gemDrops.add(new ItemStack((Item)ItemRegister.gemAmethyst));
        populated = true;
    }

    public static void addGemDrop(ItemStack stack) {
        if (!populated) {
            Crystaneer.populateGemDrops();
        }
        gemDrops.add(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.Crystaneer.desc.1", Enums.ItemDescriptionType.UNIQUE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

