/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PredicateUtil;

public class CrystikStaff
extends BaseStaff {
    public CrystikStaff(int durability) {
        super(durability);
        this.func_77655_b("CrystikStaff");
        this.setRegistryName("aoa3:crystik_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffCrystevia;
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        List targetList = caster.field_70170_p.func_175647_a(EntityLivingBase.class, caster.func_174813_aQ().func_186662_g(10.0), PredicateUtil.MAGIC_VULNERABLE_MOB);
        if (targetList.isEmpty()) {
            return null;
        }
        return targetList;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeDistortion, 2);
        runes.put(ItemRegister.runeLife, 1);
        runes.put(ItemRegister.runeWater, 1);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        for (EntityLivingBase entity : (List)args) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 50, 20, true, true));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 50, 20, true, false));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CrystikStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

