/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class EvermightStaff
extends BaseStaff {
    public EvermightStaff(int durability) {
        super(durability);
        this.func_77655_b("EvermightStaff");
        this.setRegistryName("aoa3:evermight_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffEmber;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeDistortion, 2);
        runes.put(ItemRegister.runePower, 4);
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        float healthPercent = EntityUtil.getCurrentHealthPercent(caster);
        return healthPercent < 1.0f && healthPercent > 0.0f ? Float.valueOf(healthPercent) : null;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        caster.func_70690_d(new PotionEffect(MobEffects.field_76420_g, (int)(1200.0f * (1.0f - ((Float)args).floatValue())), (double)((Float)args).floatValue() < 0.1 ? 2 : ((double)((Float)args).floatValue() < 0.5 ? 1 : 0)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.EvermightStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

