/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityShyreShot;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.ModUtil;

public class ShyreStaff
extends BaseStaff {
    public ShyreStaff(int durability) {
        super(durability);
        this.func_77655_b("ShyreStaff");
        this.setRegistryName("aoa3:shyre_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffShyre;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeEnergy, 3);
        runes.put(ItemRegister.runeDistortion, 3);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        world.func_72838_d((Entity)new EntityShyreShot(caster, this, 120));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos block, EntityLivingBase shooter) {
        shot.field_70159_w = -shot.field_70159_w * 0.1;
        shot.field_70179_y = -shot.field_70179_y * 0.1;
        shot.field_70181_x = -shot.field_70181_x * 0.1;
        block = new BlockPos(shot.field_70165_t, shot.field_70163_u, shot.field_70161_v);
        Material blockMaterial = shooter.field_70170_p.func_180495_p(block).func_185904_a();
        while (blockMaterial != Material.field_151579_a) {
            block = block.func_177984_a();
            blockMaterial = shooter.field_70170_p.func_180495_p(block).func_185904_a();
        }
        shooter.func_70634_a((double)block.func_177958_n(), (double)block.func_177956_o(), (double)block.func_177952_p());
        if (shooter instanceof EntityPlayerMP && shooter.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.lunalus) {
            ModUtil.completeAdvancement((EntityPlayerMP)shooter, "lunalus/200_iq", "lunalus_shyre_staff_travel");
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        shooter.func_70634_a((target.field_70165_t + shot.field_70165_t) / 2.0, (target.field_70163_u + shot.field_70163_u) / 2.0, (target.field_70161_v + shot.field_70161_v) / 2.0);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ShyreStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

