/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public class SkyStaff
extends BaseStaff {
    public SkyStaff(int durability) {
        super(durability);
        this.func_77655_b("SkyStaff");
        this.setRegistryName("aoa3:sky_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffSky;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeWind, 2);
        runes.put(ItemRegister.runeKinetic, 2);
        runes.put(ItemRegister.runeEnergy, 1);
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        return caster.field_70122_E ? new Object() : null;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        caster.func_70031_b(true);
        double xMotion = -MathHelper.func_76126_a((float)(caster.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(caster.field_70125_A / 180.0f * (float)Math.PI)) * 2.0f;
        double zMotion = MathHelper.func_76134_b((float)(caster.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(caster.field_70125_A / 180.0f * (float)Math.PI)) * 2.0f;
        caster.field_70181_x = Math.abs(xMotion) < 0.4 && Math.abs(zMotion) < 0.4 ? (caster.field_70181_x += 2.0) : (caster.field_70181_x += 0.75);
        caster.field_70159_w = xMotion;
        caster.field_70179_y = zMotion;
        caster.field_70133_I = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SkyStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SkyStaff.desc.2", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

