/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sword;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.capabilities.interfaces.CapabilityBaseMiscStackSerializable;
import net.tslat.aoa3.capabilities.providers.AdventMiscStackSerializeableProvider;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.item.weapon.sword.BaseSword;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public class GuardiansSword
extends BaseSword {
    public GuardiansSword(Item.ToolMaterial material, double speed) {
        super(material, speed);
        this.func_77655_b("GuardiansSword");
        this.setRegistryName("aoa3:guardians_sword");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        CapabilityBaseMiscStackSerializable cap = (CapabilityBaseMiscStackSerializable)heldStack.getCapability(AdventMiscStackSerializeableProvider.MISC_STACK, null);
        if (cap != null && cap.getValue() <= 0.0f && ItemUtil.consumeItem(player, new ItemStack((Item)ItemRegister.gemCrystallite))) {
            cap.setValue(world.func_82737_E());
            if (world instanceof WorldServer) {
                double xOffset = -MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 140.0f));
                double zOffset = MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 140.0f));
                ((WorldServer)world).func_175739_a(EnumParticleTypes.END_ROD, player.field_70165_t + xOffset, player.field_70163_u + (double)player.field_70131_O * 0.5, player.field_70161_v + zOffset, 5, xOffset, 0.0, zOffset, 0.0, new int[0]);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        ((CapabilityBaseMiscStackSerializable)stack.getCapability(AdventMiscStackSerializeableProvider.MISC_STACK, EnumFacing.NORTH)).setValue(player.func_184825_o(0.0f));
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        CapabilityBaseMiscStackSerializable cap;
        if (world.func_82737_E() % 10L == 0L && (cap = (CapabilityBaseMiscStackSerializable)stack.getCapability(AdventMiscStackSerializeableProvider.MISC_STACK, null)) != null && cap.getValue() > 0.0f && cap.getValue() < (float)(world.func_82737_E() - 2400L)) {
            cap.setValue(0.0f);
        }
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new AdventMiscStackSerializeableProvider();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap attributeMap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            int buff = 0;
            CapabilityBaseMiscStackSerializable cap = (CapabilityBaseMiscStackSerializable)stack.getCapability(AdventMiscStackSerializeableProvider.MISC_STACK, null);
            if (cap != null && cap.getValue() > 0.0f) {
                buff = 5;
            }
            ItemUtil.setAttribute((Multimap<String, AttributeModifier>)attributeMap, SharedMonsterAttributes.field_111264_e, field_111210_e, this.dmg + (float)buff);
        }
        return attributeMap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.GuardiansSword.desc.1", Enums.ItemDescriptionType.POSITIVE));
    }
}

