/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.leaderboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class Leaderboard
implements Serializable {
    private final ArrayList<LeaderboardEntry> leaderboardArray = new ArrayList(ConfigurationUtil.MainConfig.leaderboardCapacity);
    private final HashMap<UUID, Integer> indexMap = new HashMap(ConfigurationUtil.MainConfig.leaderboardCapacity);
    private int lowestIndex = 0;
    @Nullable
    private Enums.Skills skill;

    public Leaderboard(@Nullable Enums.Skills skill) {
        this.skill = skill;
    }

    @Nullable
    protected int getPlayerRank(EntityPlayer pl) {
        return this.indexMap.get(pl.func_110124_au());
    }

    protected void addOrUpdatePlayer(EntityPlayer pl, int level) {
        UUID uuid = pl.func_110124_au();
        if (this.indexMap.containsKey(uuid)) {
            int index = this.indexMap.get(uuid);
            LeaderboardEntry entry = this.leaderboardArray.get(index).update(pl, level);
            if (this.leaderboardArray.size() > 1) {
                this.leaderboardArray.remove(index);
                for (int i = index; i >= 0; --i) {
                    if (this.leaderboardArray.get(i).getLvl() < level) continue;
                    this.leaderboardArray.add(i + 1, entry);
                    this.indexMap.put(uuid, i + 1);
                    break;
                }
            }
        } else if (this.leaderboardArray.size() == 0) {
            this.leaderboardArray.add(0, new LeaderboardEntry(pl, level));
            this.indexMap.put(uuid, 0);
        } else {
            int i;
            for (i = this.lowestIndex; i >= 0; --i) {
                LeaderboardEntry entry = this.leaderboardArray.get(i);
                if (entry == null || entry.getLvl() < level) continue;
                if (i + 1 < ConfigurationUtil.MainConfig.leaderboardCapacity) {
                    if (this.lowestIndex == ConfigurationUtil.MainConfig.leaderboardCapacity - 1) {
                        this.indexMap.remove(this.leaderboardArray.get(this.lowestIndex).getUuid());
                        this.leaderboardArray.remove(this.lowestIndex);
                    }
                    this.leaderboardArray.add(i + 1, entry.update(pl, level));
                    this.indexMap.put(uuid, i + 1);
                }
                return;
            }
            if (i == -1) {
                this.leaderboardArray.add(0, new LeaderboardEntry(pl, level));
                this.indexMap.put(uuid, 0);
            }
        }
    }

    protected void removePlayer(EntityPlayer pl) {
        UUID uuid = pl.func_110124_au();
        if (this.indexMap.containsKey(uuid)) {
            LeaderboardEntry entry = this.leaderboardArray.get(this.indexMap.get(uuid));
            this.leaderboardArray.remove(entry);
            this.indexMap.remove(uuid);
        }
    }

    protected LeaderboardDataPackage getTopTen() {
        return this.getSurroundingRankEntries(null);
    }

    protected LeaderboardDataPackage getSurroundingRankEntries(@Nullable EntityPlayer pl) {
        LeaderboardEntry entry;
        int firstRank = pl == null ? 4 : Math.max(4, this.indexMap.containsKey(pl.func_110124_au()) ? this.indexMap.get(pl.func_110124_au()) : this.lowestIndex - 5) - 4;
        ArrayList<TrimmedLeaderboardEntry> resultArray = new ArrayList<TrimmedLeaderboardEntry>(10);
        for (int i = firstRank; i <= firstRank + 10 && i < this.leaderboardArray.size() && (entry = this.leaderboardArray.get(i)) != null; ++i) {
            resultArray.add(new TrimmedLeaderboardEntry(entry));
        }
        return new LeaderboardDataPackage(this.skill, firstRank, resultArray);
    }

    public static class LeaderboardEntry
    implements Serializable {
        private final UUID uuid;
        private String name;
        private int lvl;

        private LeaderboardEntry(EntityPlayer pl, int level) {
            this.uuid = pl.func_110124_au();
            this.name = pl.func_70005_c_();
            this.lvl = level;
        }

        public NBTTagCompound asNBTTag(int rank) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Rank", rank);
            tag.func_74778_a("Name", this.name);
            tag.func_74768_a("Lvl", this.lvl);
            return tag;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public int getLvl() {
            return this.lvl;
        }

        private LeaderboardEntry update(EntityPlayer pl, int level) {
            this.lvl = level;
            if (!this.name.equals(pl.func_70005_c_())) {
                this.name = pl.func_70005_c_();
            }
            return this;
        }
    }

    public static class TrimmedLeaderboardEntry
    implements Serializable {
        public final String name;
        public final int lvl;

        private TrimmedLeaderboardEntry(LeaderboardEntry entry) {
            this.name = entry.getName();
            this.lvl = entry.getLvl();
        }
    }

    public static class LeaderboardDataPackage {
        @Nullable
        public final Enums.Skills skill;
        public final int firstRank;
        public final ArrayList<TrimmedLeaderboardEntry> entries;

        private LeaderboardDataPackage(@Nullable Enums.Skills skill, int topRank, ArrayList<TrimmedLeaderboardEntry> entries) {
            this.skill = skill;
            this.firstRank = topRank;
            this.entries = entries;
        }
    }
}

