/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.leaderboard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.leaderboard.Leaderboard;
import net.tslat.aoa3.utils.ConfigurationUtil;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class LeaderboardDataHandler {
    private static File dataDir;
    private static final HashMap<Enums.Skills, Leaderboard> leaderboards;

    protected static void init() {
        if (!ConfigurationUtil.MainConfig.leaderboardEnabled) {
            return;
        }
        File worldDir = new File(FMLCommonHandler.instance().getSavesDirectory(), FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I());
        File dataDir = new File(worldDir, "data");
        LeaderboardDataHandler.dataDir = new File(dataDir, "aoaleaderboards");
        if (!LeaderboardDataHandler.dataDir.exists()) {
            LeaderboardDataHandler.dataDir.mkdirs();
        }
        LeaderboardDataHandler.loadLeaderboard(null);
        for (Enums.Skills skill : Enums.Skills.values()) {
            LeaderboardDataHandler.loadLeaderboard(skill);
        }
    }

    public static Leaderboard getLeaderboard(@Nullable Enums.Skills skill) {
        return leaderboards.get((Object)skill);
    }

    /*
     * Exception decompiling
     */
    private static void loadLeaderboard(@Nullable Enums.Skills skill) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void saveAllLeaderboards() {
        for (Enums.Skills skill : leaderboards.keySet()) {
            LeaderboardDataHandler.saveLeaderboard(skill);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void saveLeaderboard(@Nullable Enums.Skills skill) {
        FileOutputStream fos;
        block15: {
            File skillFile = new File(dataDir, (skill == null ? "totals" : skill.toString()) + ".aoa3");
            Leaderboard leaderboard = leaderboards.get((Object)skill);
            if (leaderboard == null) {
                return;
            }
            if (!skillFile.exists()) {
                try {
                    skillFile.createNewFile();
                }
                catch (IOException e) {
                    AdventOfAscension.logMessage(Level.ERROR, "No file access to leaderboard files in " + dataDir.getAbsolutePath() + ", disabling leaderboards");
                    e.printStackTrace();
                }
            }
            fos = null;
            ObjectOutputStream oos = null;
            try {
                fos = new FileOutputStream(skillFile);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(leaderboard);
                oos.close();
                if (oos == null) break block15;
            }
            catch (FileNotFoundException e) {
                block16: {
                    AdventOfAscension.logMessage(Level.ERROR, "Unable to save leaderboard to file: I can't create the file!");
                    e.printStackTrace();
                    if (oos == null) break block16;
                    IOUtils.closeQuietly((OutputStream)oos);
                }
                if (fos != null) {
                    IOUtils.closeQuietly((OutputStream)fos);
                }
                return;
            }
            catch (IOException e2) {
                block17: {
                    AdventOfAscension.logMessage(Level.ERROR, "Unable to save leaderboard to file: Failure to write to file");
                    e2.printStackTrace();
                    if (oos == null) break block17;
                    {
                        catch (Throwable throwable) {
                            if (oos != null) {
                                IOUtils.closeQuietly(oos);
                            }
                            if (fos != null) {
                                IOUtils.closeQuietly((OutputStream)fos);
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)oos);
                }
                if (fos != null) {
                    IOUtils.closeQuietly((OutputStream)fos);
                }
                return;
            }
            IOUtils.closeQuietly((OutputStream)oos);
        }
        if (fos != null) {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    static {
        leaderboards = new HashMap(Enums.Skills.values().length + 1);
    }
}

