/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class PlayerHasTribute
implements LootCondition {
    private final Enums.Deities deity;
    private final int amount;

    public PlayerHasTribute(Enums.Deities deity, int amount) {
        this.deity = deity;
        this.amount = amount;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        return context.func_186495_b() != null && PlayerUtil.getAdventPlayer((EntityPlayer)context.func_186495_b()).stats().getTribute(this.deity) >= this.amount;
    }

    public static class Serializer
    extends LootCondition.Serializer<PlayerHasTribute> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "player_has_tribute"), PlayerHasTribute.class);
        }

        public void serialize(JsonObject json, PlayerHasTribute value, JsonSerializationContext context) {
            json.addProperty("deity", value.deity.toString().toLowerCase());
            json.addProperty("amount", (Number)value.amount);
        }

        public PlayerHasTribute deserialize(JsonObject json, JsonDeserializationContext context) {
            return new PlayerHasTribute(Enums.Deities.valueOf(JsonUtils.func_151200_h((JsonObject)json, (String)"deity").toUpperCase()), JsonUtils.func_151203_m((JsonObject)json, (String)"amount"));
        }
    }
}

