/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PlayerHoldingItem
implements LootCondition {
    private final Item tool;
    private final EnumHand hand;

    public PlayerHoldingItem(Item heldTool, @Nullable EnumHand hand) {
        this.tool = heldTool;
        this.hand = hand;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        if (this.hand != null) {
            return context.func_186495_b() instanceof EntityPlayer && ((EntityPlayer)context.func_186495_b()).func_184586_b(this.hand).func_77973_b() == this.tool;
        }
        if (context.func_186495_b() instanceof EntityPlayer) {
            for (ItemStack stack : context.func_186495_b().func_184214_aD()) {
                if (stack.func_77973_b() != this.tool) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<PlayerHoldingItem> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "player_holding_item"), PlayerHoldingItem.class);
        }

        public void serialize(JsonObject json, PlayerHoldingItem value, JsonSerializationContext context) {
            json.addProperty("id", value.tool.getRegistryName() == null ? "" : value.tool.getRegistryName().toString());
            json.addProperty("hand", value.hand.toString());
        }

        public PlayerHoldingItem deserialize(JsonObject json, JsonDeserializationContext context) {
            return new PlayerHoldingItem((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"id"))), JsonUtils.func_151204_g((JsonObject)json, (String)"hand") ? EnumHand.valueOf((String)JsonUtils.func_151200_h((JsonObject)json, (String)"hand").toUpperCase()) : null);
        }
    }
}

