/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class GrantTribute
extends LootFunction {
    private final Enums.Deities deity;
    private final int amount;

    public GrantTribute(LootCondition[] conditionsIn, Enums.Deities deity, int amount) {
        super(conditionsIn);
        this.deity = deity;
        this.amount = amount;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (context.func_186495_b() instanceof EntityPlayer) {
            PlayerUtil.getAdventPlayer((EntityPlayer)context.func_186495_b()).stats().addTribute(this.deity, this.amount);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<GrantTribute> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "give_tribute"), GrantTribute.class);
        }

        public void serialize(JsonObject json, GrantTribute functionInstance, JsonSerializationContext serializationContext) {
            json.addProperty("deity", functionInstance.deity.toString().toLowerCase());
            json.addProperty("amount", (Number)functionInstance.amount);
        }

        public GrantTribute deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] lootConditions) {
            return new GrantTribute(lootConditions, Enums.Deities.valueOf(JsonUtils.func_151200_h((JsonObject)json, (String)"deity").toUpperCase()), JsonUtils.func_151203_m((JsonObject)json, (String)"amount"));
        }
    }
}

