/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.scheduling.async;

import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.tslat.aoa3.block.functional.lamps.LampBlock;
import net.tslat.aoa3.entity.boss.shadowlord.EntityShadowlord;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.StringUtil;

public class ShadowlordSpawnTask
implements Runnable {
    private final EntityPlayer player;
    private final BlockPos altarPosition;
    private boolean spawning = false;
    private boolean spawned = false;

    public ShadowlordSpawnTask(EntityPlayer player, BlockPos altarPosition) {
        this.player = player;
        this.altarPosition = altarPosition;
    }

    @Override
    public void run() {
        if (this.spawned) {
            for (int x = -2; x <= 2; x += 4) {
                for (int z = -2; z <= 2; z += 4) {
                    BlockPos pos = this.altarPosition.func_177982_a(x, 1, z);
                    Block block = this.player.field_70170_p.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof LampBlock)) continue;
                    this.player.field_70170_p.func_175656_a(pos, ((LampBlock)block).getOnLamp().func_176223_P().func_177226_a((IProperty)LampBlock.FIXED_LAMP, (Comparable)Boolean.valueOf(true)));
                }
            }
        } else if (this.spawning) {
            this.spawned = true;
            EntityShadowlord shadowlord = new EntityShadowlord(this.player.field_70170_p);
            shadowlord.func_70012_b(this.altarPosition.func_177958_n(), this.altarPosition.func_177956_o() + 3, this.altarPosition.func_177952_p(), 0.0f, 0.0f);
            this.player.field_70170_p.func_72838_d((Entity)shadowlord);
            StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.shadowlord.spawn", this.player.getDisplayNameString()), (Entity)this.player, 50);
            this.schedule(5, TimeUnit.SECONDS);
        } else {
            for (int x = -2; x <= 2; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos pos = this.altarPosition.func_177982_a(x, y, z);
                        IBlockState state = this.player.field_70170_p.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (!(block instanceof LampBlock) || block == ((LampBlock)block).getOffLamp()) continue;
                        this.player.field_70170_p.func_180501_a(pos, ((LampBlock)block).getOffLamp().func_176223_P(), 2);
                        this.schedule(2, TimeUnit.SECONDS);
                        this.player.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
                        return;
                    }
                }
            }
            this.spawning = true;
            this.schedule(1, TimeUnit.SECONDS);
        }
    }

    public void schedule(Integer time, TimeUnit units) {
        ModUtil.scheduleRequiredAsyncTask(this, time, units);
    }
}

