/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.scheduling.sync;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ModUtil;

public class UltimatumStaffTask
implements Runnable {
    private final int startingTick = GlobalEvents.tick;
    private final EntityLivingBase shooter;
    private final EntityLivingBase target;
    private final BlockPos shooterPos;
    private final BlockPos targetPos;
    private final float shooterStartHealth;
    private final float targetStartHealth;
    private boolean targetTurn = true;

    public UltimatumStaffTask(EntityLivingBase shooter, EntityLivingBase target) {
        this.shooter = shooter;
        this.target = target;
        this.shooterPos = shooter.func_180425_c();
        this.targetPos = target.func_180425_c();
        this.shooterStartHealth = shooter.func_110143_aJ();
        this.targetStartHealth = target.func_110143_aJ();
        target.field_70159_w = 0.0;
        target.field_70181_x = 0.0;
        target.field_70179_y = 0.0;
        shooter.field_70159_w = 0.0;
        shooter.field_70181_x = 0.0;
        shooter.field_70179_y = 0.0;
        EntityUtil.safelyRemovePotionEffects(target, MobEffects.field_76428_l);
        target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 210, 100, true, false));
        target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 210, 50, true, false));
        target.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 210, 5, true, false));
        target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 210, 0, true, false));
        target.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 510, 0, true, false));
        target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 210, -1, true, false));
        EntityUtil.safelyRemovePotionEffects(target, MobEffects.field_76428_l);
        shooter.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 210, 100, true, false));
        shooter.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 210, 50, true, false));
        shooter.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 210, 5, true, false));
        shooter.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 510, 5, true, false));
        shooter.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 210, 0, true, false));
        shooter.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 210, -1, true, false));
    }

    @Override
    public void run() {
        if (this.shooter == null || this.target == null || this.shooter.field_70170_p.field_72995_K || !this.shooter.func_180425_c().equals((Object)this.shooterPos) || !this.target.func_180425_c().equals((Object)this.targetPos)) {
            this.resetStates();
            return;
        }
        float healthPercent = 1.0f - (float)(GlobalEvents.tick - this.startingTick) / 200.0f;
        float targetPostHealth = this.targetStartHealth * healthPercent;
        float shooterPostHealth = this.shooterStartHealth * healthPercent;
        if (this.targetTurn) {
            if (this.target.func_110143_aJ() == 0.0f) {
                this.resetStates();
                return;
            }
            if (targetPostHealth <= 0.0f) {
                this.resetStates();
                EntityUtil.dealMagicDamage(null, this.shooter, (Entity)this.target, this.target.func_110143_aJ() - targetPostHealth, true);
                this.target.field_70159_w = 0.0;
                this.target.field_70181_x = 0.0;
                this.target.field_70179_y = 0.0;
            } else {
                this.target.func_70606_j(targetPostHealth);
            }
            ((WorldServer)this.shooter.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, this.target.field_70165_t, this.target.field_70163_u + (double)this.target.field_70131_O, this.target.field_70161_v, (int)Math.ceil(10.0f * healthPercent), 0.0, 0.0, 0.0, 0.0, new int[0]);
        } else if (!(this.shooter instanceof EntityPlayer) || !((EntityPlayer)this.shooter).field_71075_bZ.field_75098_d) {
            if (shooterPostHealth <= 0.0f) {
                this.resetStates();
                EntityUtil.dealSelfHarmDamage(this.shooter, this.shooter.func_110143_aJ() - shooterPostHealth);
            } else {
                this.shooter.func_70606_j(shooterPostHealth);
            }
            ((WorldServer)this.shooter.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, this.shooter.field_70165_t, this.shooter.field_70163_u + (double)this.shooter.field_70131_O, this.shooter.field_70161_v, (int)Math.ceil(10.0f * healthPercent), 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
        this.targetTurn = !this.targetTurn;
        ModUtil.scheduleSyncronisedTask(this, 1);
    }

    private void resetStates() {
        if (this.target.func_110143_aJ() > 0.0f) {
            EntityUtil.safelyRemovePotionEffects(this.target, MobEffects.field_76440_q, MobEffects.field_76429_m, MobEffects.field_76437_t, MobEffects.field_76421_d, MobEffects.field_188424_y, MobEffects.field_76439_r);
        }
        if (this.shooter.func_110143_aJ() > 0.0f) {
            EntityUtil.safelyRemovePotionEffects(this.shooter, MobEffects.field_76440_q, MobEffects.field_76429_m, MobEffects.field_76437_t, MobEffects.field_76421_d, MobEffects.field_188424_y, MobEffects.field_76439_r);
        }
    }
}

