/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils;

import java.util.ArrayList;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class PotionUtil {

    public static class PotionBuilder {
        Item potionItem;
        String displayName = null;
        boolean translatable = false;
        ArrayList<PotionEffect> effects = null;
        Integer colour = null;
        boolean dynamicColour = false;

        public PotionBuilder(Item potionItem) {
            this.potionItem = potionItem;
        }

        public PotionBuilder withName(String name) {
            this.displayName = name;
            return this;
        }

        public PotionBuilder withTranslationKey(String nameLangKey) {
            this.displayName = nameLangKey;
            this.translatable = true;
            return this;
        }

        public PotionBuilder addEffect(PotionEffect effect) {
            if (this.effects == null) {
                this.effects = new ArrayList(1);
            }
            this.effects.add(effect);
            return this;
        }

        public PotionBuilder withColour(int colour) {
            this.colour = Integer.parseInt(String.valueOf(colour), 16);
            return this;
        }

        public PotionBuilder enableDynamicColour() {
            this.dynamicColour = true;
            return this;
        }

        public ItemStack build() {
            NBTTagCompound displayCompound;
            ItemStack stack = new ItemStack(this.potionItem);
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.displayName != null) {
                displayCompound = new NBTTagCompound();
                displayCompound.func_74778_a(this.translatable ? "LocName" : "Name", this.displayName);
                nbt.func_74782_a("display", (NBTBase)displayCompound);
            }
            if (this.dynamicColour && this.effects != null) {
                this.colour = PotionUtils.func_185181_a(this.effects);
            }
            if (this.colour != null) {
                displayCompound = new NBTTagCompound();
                if (nbt.func_74764_b("display")) {
                    displayCompound = (NBTTagCompound)nbt.func_74781_a("display");
                }
                displayCompound.func_74778_a("Color", "#" + Integer.toHexString(this.colour));
            }
            stack.func_77982_d(nbt);
            if (this.effects != null && !this.effects.isEmpty()) {
                PotionEffect primaryEffect = this.effects.get(0);
                PotionType attemptedType = (PotionType)PotionType.field_185176_a.func_82594_a((Object)primaryEffect.func_188419_a().getRegistryName());
                if (attemptedType != PotionTypes.field_185229_a) {
                    PotionUtils.func_185188_a((ItemStack)stack, (PotionType)attemptedType);
                    this.effects.remove(0);
                }
                PotionUtils.func_185184_a((ItemStack)stack, this.effects);
            }
            return stack;
        }
    }
}

