/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils.skills;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.Tuple;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;

public final class HunterUtil {
    private static final HashMap<Class<? extends EntityLivingBase>, Tuple<Integer, Float>> hunterCreatureMap = new HashMap();

    public static void registerHunterCreature(Class<? extends EntityLivingBase> creatureClass, int requiredLevel, float xpForKill) {
        if (!hunterCreatureMap.containsKey(creatureClass)) {
            hunterCreatureMap.put(creatureClass, (Tuple<Integer, Float>)new Tuple((Object)requiredLevel, (Object)Float.valueOf(xpForKill)));
        } else {
            AdventOfAscension.logOptionalMessage("Creature " + creatureClass.toString() + " is already registered as a hunter creature. Skipping duplicate entry");
        }
    }

    public static boolean canAttackTarget(@Nonnull EntityLivingBase target, @Nullable Entity attacker, boolean notifyPlayer) {
        boolean success;
        EntityPlayer player;
        if (attacker == null || !hunterCreatureMap.containsKey(target.getClass())) {
            return true;
        }
        int lvl = (Integer)hunterCreatureMap.get(target.getClass()).func_76341_a();
        Object object = attacker instanceof EntityPlayer ? (EntityPlayer)attacker : (attacker instanceof EntityTameable ? (((EntityTameable)attacker).func_70902_q() instanceof EntityPlayer ? (EntityPlayer)((EntityTameable)attacker).func_70902_q() : null) : (player = null));
        if (player == null) {
            return false;
        }
        boolean bl = success = player.field_71075_bZ.field_75098_d || !target.field_70170_p.field_72995_K && PlayerUtil.doesPlayerHaveLevel(player, Enums.Skills.HUNTER, lvl);
        if (!success && notifyPlayer && !player.field_70170_p.field_72995_K) {
            PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.HUNTER, lvl);
        }
        return success;
    }

    public static boolean doesPlayerMeetHunterReq(@Nonnull EntityLivingBase hunterCreature, @Nonnull EntityPlayer player) {
        if (!hunterCreatureMap.containsKey(hunterCreature.getClass())) {
            return true;
        }
        return PlayerUtil.doesPlayerHaveLevel(player, Enums.Skills.HUNTER, (Integer)hunterCreatureMap.get(hunterCreature.getClass()).func_76341_a());
    }

    public static boolean isHunterCreature(@Nonnull EntityLivingBase entity) {
        return hunterCreatureMap.containsKey(entity.getClass());
    }

    public static int getHunterLevel(@Nullable EntityLivingBase entity) {
        if (entity == null || !hunterCreatureMap.containsKey(entity.getClass())) {
            return -1;
        }
        return (Integer)hunterCreatureMap.get(entity.getClass()).func_76341_a();
    }

    public static float getHunterXp(@Nullable EntityLivingBase entity) {
        if (entity == null || !hunterCreatureMap.containsKey(entity.getClass())) {
            return -1.0f;
        }
        return ((Float)hunterCreatureMap.get(entity.getClass()).func_76340_b()).floatValue();
    }
}

