/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.RegistryNamespaced;
import net.minecraftforge.event.world.WorldEvent;

public class StatManager {
    private static Map<String, StatBase> registerdStats = Maps.newHashMap();
    public StatTypeUseItem StatUse = new StatTypeUseItem(StatList.objectUseStats, Item.itemRegistry, "stat.useItem", StatList.itemStats);
    public StatType<Item> StatCrafts = new StatType(StatList.objectCraftStats, Item.itemRegistry, "stat.craftItem");
    public StatType<Item> StatBreak = new StatType(StatList.objectBreakStats, Item.itemRegistry, "stat.breakItem");
    public StatTypeHasViewList<Block> StatMineBlock = new StatTypeHasViewList(StatList.mineBlockStatArray, Block.blockRegistry, "stat.mineBlock", StatList.objectMineStats);

    @SubscribeEvent
    public void WoldLoadEvent(WorldEvent.Load event) {
        this.StatUse.remapStats();
        this.StatCrafts.remapStats();
        this.StatBreak.remapStats();
        this.StatMineBlock.remapStats();
    }

    public void registerItemStat(Item useItem, Item viewItem, String key) {
        this.StatUse.registerStat(useItem, viewItem, key);
        this.StatCrafts.registerStat(useItem, viewItem, key);
        this.StatBreak.registerStat(useItem, viewItem, key);
    }

    public void registerBlockStat(Block useBlock, ItemBlock viewItem, String key) {
        Item useItem = Item.func_150898_a((Block)useBlock);
        if (useItem != null) {
            this.StatUse.registerStat(useItem, (Item)viewItem, key);
            this.StatCrafts.registerStat(useItem, (Item)viewItem, key);
        }
        this.StatMineBlock.registerStat(useBlock, (Item)viewItem, key);
    }

    public class StatType<T> {
        protected Multimap<StatCrafting, Integer> registerdStatsSlotIndex = HashMultimap.create();
        protected Multimap<StatCrafting, T> registerdStatsSlotObject = HashMultimap.create();
        protected StatBase[] stats;
        protected RegistryNamespaced registry;
        protected String keyBase;

        public StatType(StatBase[] stats, RegistryNamespaced registry, String keyBase) {
            this.stats = stats;
            this.registry = registry;
            this.keyBase = keyBase;
        }

        public void remapStats() {
            HashSet workedIds = Sets.newHashSet();
            for (Map.Entry entry : this.registerdStatsSlotIndex.entries()) {
                int id = (Integer)entry.getValue();
                if (workedIds.contains(id) || this.stats[id] != entry.getKey()) continue;
                this.stats[id] = null;
                workedIds.add(id);
            }
            this.registerdStatsSlotIndex.clear();
            for (Map.Entry entry : this.registerdStatsSlotObject.entries()) {
                int id = this.registry.getIDForObject(entry.getValue());
                StatCrafting stat = (StatCrafting)entry.getKey();
                this.stats[id] = stat;
                this.registerdStatsSlotIndex.put((Object)stat, (Object)id);
            }
        }

        private StatCrafting getStat(Item viewItem, String key) {
            StatCrafting stat;
            String statKey = this.keyBase + "." + key;
            if (!registerdStats.containsKey(statKey)) {
                stat = new StatCrafting(statKey, (IChatComponent)new ChatComponentTranslation(this.keyBase, new Object[]{new ItemStack(viewItem).func_151000_E()}), viewItem);
                stat.func_75971_g();
                registerdStats.put(statKey, stat);
            } else {
                stat = (StatCrafting)registerdStats.get(statKey);
            }
            return stat;
        }

        public StatCrafting registerStat(T use, Item viewItem, String key) {
            if (viewItem == null) {
                viewItem = Item.func_150899_d((int)this.registry.getIDForObject(use));
            }
            if (use != null && viewItem != null) {
                StatCrafting stat = this.getStat(viewItem, key);
                this.registerdStatsSlotObject.put((Object)stat, use);
                return stat;
            }
            return null;
        }
    }

    public class StatTypeHasViewList<T>
    extends StatType<T> {
        protected List viewlist;

        public StatTypeHasViewList(StatBase[] stats, RegistryNamespaced registry, String keyBase, List viewlist) {
            super(stats, registry, keyBase);
            this.viewlist = viewlist;
        }

        @Override
        public StatCrafting registerStat(T use, Item viewItem, String key) {
            Boolean isAdded = registerdStats.containsKey(this.keyBase + "." + key);
            StatCrafting stat = super.registerStat(use, viewItem, key);
            if (stat != null && this.viewlist != null && !isAdded.booleanValue()) {
                this.AddViewList(stat, viewItem);
            }
            return stat;
        }

        protected void AddViewList(StatCrafting stat, Item viewItem) {
            this.viewlist.add(stat);
        }
    }

    public class StatTypeUseItem
    extends StatTypeHasViewList<Item> {
        public StatTypeUseItem(StatBase[] stats, RegistryNamespaced registry, String keyBase, List viewlist) {
            super(stats, registry, keyBase, viewlist);
        }

        @Override
        protected void AddViewList(StatCrafting stat, Item viewItem) {
            if (!(viewItem instanceof ItemBlock)) {
                super.AddViewList(stat, viewItem);
            }
        }
    }
}

