/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DamageLimitter {
    static float factor = 1.0f;
    static float limit = -1.0f;

    public static void setLimit(float limit) {
        DamageLimitter.limit = limit < 0.0f ? Float.MAX_VALUE : Math.max(1.0f, limit);
    }

    public static float getLimit() {
        return limit;
    }

    public static void setFactor(float factor) {
        DamageLimitter.factor = Math.max(0.01f, Math.min(factor, 10.0f));
    }

    public static float getFactor() {
        return factor;
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        Entity attacker = event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        if (!(attacker instanceof EntityLivingBase)) {
            return;
        }
        ItemStack stack = ((EntityLivingBase)attacker).func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        amount *= DamageLimitter.getFactor();
        amount = Math.max(1.0f, Math.min(amount, DamageLimitter.getLimit()));
        event.setAmount(amount);
    }
}

