/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.capability.MobEffect.CapabilityMobEffectHandler;
import mods.flammpfeil.slashblade.capability.MobEffect.IMobEffectHandler;
import mods.flammpfeil.slashblade.entity.ai.EntityAIStun;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StunManager {
    static final String FreezeTimeout = "FreezeTimeout";
    static final long freezeLimit = 200L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.getEntity();
        entity.field_70714_bg.func_75776_a(-1, (EntityAIBase)new EntityAIStun((EntityLivingBase)entity));
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (target == null) {
            return;
        }
        if (target.field_70170_p == null) {
            return;
        }
        IMobEffectHandler mobEffect = (IMobEffectHandler)target.getCapability(CapabilityMobEffectHandler.MOB_EFFECT, null);
        if (mobEffect == null) {
            return;
        }
        if (!mobEffect.isStun(target.field_70170_p.func_82737_E(), 200L)) {
            return;
        }
        if (target.field_70181_x < 0.0) {
            target.field_70181_x *= 0.5;
        }
    }

    public static void setStun(EntityLivingBase target, long duration) {
        if (target.field_70170_p == null) {
            return;
        }
        if (!(target instanceof EntityLiving)) {
            return;
        }
        if (duration <= 0L) {
            return;
        }
        duration = Math.min(duration, 200L);
        IMobEffectHandler mobEffect = (IMobEffectHandler)target.getCapability(CapabilityMobEffectHandler.MOB_EFFECT, null);
        if (mobEffect == null) {
            return;
        }
        mobEffect.setStunTimeOut(target.field_70170_p.func_82737_E() + duration);
    }

    public static void removeStun(EntityLivingBase target) {
        if (target.field_70170_p == null) {
            return;
        }
        if (!(target instanceof EntityLiving)) {
            return;
        }
        IMobEffectHandler mobEffect = (IMobEffectHandler)target.getCapability(CapabilityMobEffectHandler.MOB_EFFECT, null);
        if (mobEffect == null) {
            return;
        }
        mobEffect.clearFreezeTimeOut();
        mobEffect.clearStunTimeOut();
    }

    @SubscribeEvent
    public void onEntityCanUpdate(EntityEvent.CanUpdate event) {
        if (event.isCanceled()) {
            return;
        }
        Entity target = event.getEntity();
        if (target == null) {
            return;
        }
        if (target.field_70170_p == null) {
            return;
        }
        IMobEffectHandler mobEffect = (IMobEffectHandler)target.getCapability(CapabilityMobEffectHandler.MOB_EFFECT, null);
        if (mobEffect == null) {
            return;
        }
        if (mobEffect.isFreeze(target.field_70170_p.func_82737_E(), 200L)) {
            event.setCanUpdate(false);
        }
    }

    public static void setFreeze(EntityLivingBase target, long duration) {
        long timeout;
        if (target.field_70170_p == null) {
            return;
        }
        if (!(target instanceof EntityLiving)) {
            return;
        }
        if (duration <= 0L) {
            return;
        }
        duration = Math.min(duration, 200L);
        IMobEffectHandler mobEffect = (IMobEffectHandler)target.getCapability(CapabilityMobEffectHandler.MOB_EFFECT, null);
        if (mobEffect == null) {
            return;
        }
        long oldTimeout = mobEffect.getFreezeTimeOut();
        if (oldTimeout < (timeout = target.field_70170_p.func_82737_E() + duration)) {
            mobEffect.setFreezeTimeOut(timeout);
        }
    }
}

