/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.SpecialEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class BladeCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<NBTBase> {
    @CapabilityInject(value=IEnergyStorage.class)
    public static Capability<IEnergyStorage> ENERGY = null;
    protected final ItemStack container;
    static final String tagParent = "Parent";
    protected IEnergyStorage storage = null;
    static final String tagEnergyStorage = "EnergyStorage";
    static final String tagCapacity = "Capacity";
    static final String tagEnergy = "Energy";
    static final int defaultCapacity = 1000000;
    private static Map<Integer, Integer> defaultCapacityMap = new HashMap<Integer, Integer>(){
        {
            this.put(1, 100000);
            this.put(2, 150000);
            this.put(3, 250000);
            this.put(4, 1000000);
        }
    };

    public BladeCapabilityProvider(ItemStack container, NBTTagCompound capNBT) {
        NBTTagCompound tag;
        this.container = container;
        if (capNBT != null && capNBT.func_74764_b(tagParent) && (tag = capNBT.func_74775_l(tagParent)).func_74764_b(tagEnergyStorage)) {
            this.storage = new EnergyStorage(1000000);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        this.updateStorage();
        return capability == ENERGY && this.storage != null;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        this.updateStorage();
        if (capability == ENERGY) {
            return (T)this.storage;
        }
        return null;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound parentTag = new NBTTagCompound();
        this.updateStorage();
        if (this.storage != null) {
            NBTTagCompound tag = new NBTTagCompound();
            parentTag.func_74782_a(tagEnergyStorage, (NBTBase)tag);
            tag.func_74768_a(tagCapacity, this.storage.getMaxEnergyStored());
            tag.func_74782_a(tagEnergy, ENERGY.writeNBT((Object)this.storage, null));
        }
        return parentTag;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound parentTag = (NBTTagCompound)nbt;
        if (parentTag.func_74764_b(tagEnergyStorage)) {
            NBTTagCompound tag = parentTag.func_74775_l(tagEnergyStorage);
            int capacity = tag.func_74762_e(tagCapacity);
            this.storage = new EnergyStorage(capacity);
            ENERGY.readNBT((Object)this.storage, null, tag.func_74781_a(tagEnergy));
        }
    }

    private void updateStorage() {
        NBTTagCompound tag = ItemSlashBlade.getSpecialEffect(this.container);
        int level = tag.func_74762_e(SpecialEffects.HFCustom.getEffectKey());
        if (0 < level) {
            int newCapacity = BladeCapabilityProvider.getDefaultCapacity(this.container);
            if (this.storage == null) {
                this.storage = new EnergyStorage(newCapacity);
            } else {
                int currentCapacity = this.storage.getMaxEnergyStored();
                if (currentCapacity != newCapacity) {
                    NBTBase stored = ENERGY.writeNBT((Object)this.storage, null);
                    this.storage = new EnergyStorage(newCapacity);
                    ENERGY.readNBT((Object)this.storage, null, stored);
                }
            }
        }
    }

    private static int getDefaultCapacity(ItemStack stack) {
        int effectLevel = ItemSlashBlade.getSpecialEffect(stack).func_74762_e(SpecialEffects.HFCustom.getEffectKey());
        if (defaultCapacityMap.containsKey(effectLevel)) {
            return defaultCapacityMap.get(effectLevel);
        }
        if (effectLevel <= 0) {
            return 0;
        }
        return 1000000;
    }
}

