/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.model;

import java.awt.Color;
import java.util.EnumSet;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;
import mods.flammpfeil.slashblade.ItemSlashBladeWrapper;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.model.BladeModel;
import mods.flammpfeil.slashblade.client.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.model.obj.Face;
import mods.flammpfeil.slashblade.client.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.entity.BladeFirstPersonRender;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ResourceLocationRaw;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BladeSpecialRender
extends TileEntityItemStackRenderer {
    private static final ResourceLocationRaw RES_ITEM_GLINT = new ResourceLocationRaw("textures/misc/enchanted_item_glint.png");

    public static BladeSpecialRender getInstance() {
        return SingletonHolder.instance;
    }

    public void func_179022_a(ItemStack itemStackIn) {
        ItemSlashBlade.isRenderThread.set(false);
        if (BladeModel.targetStack.func_190926_b()) {
            return;
        }
        ResourceLocationRaw resourceTexture = BladeModel.itemBlade.getModelTexture(BladeModel.targetStack);
        this.bindTexture(resourceTexture);
        if (this.render() && BladeModel.targetStack.func_77962_s()) {
            this.renderEffect();
        }
    }

    private void renderEffect() {
        if (!SlashBlade.RenderEnchantEffect) {
            return;
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.bindTexture(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
    }

    boolean checkRenderNaked() {
        ItemStack mainHand = BladeModel.user.func_184614_ca();
        if (ItemSlashBlade.hasScabbardInOffhand(BladeModel.user)) {
            return true;
        }
        EnumSet<ItemSlashBlade.SwordType> type = BladeModel.itemBlade.getSwordType(mainHand);
        return type.contains((Object)ItemSlashBlade.SwordType.NoScabbard);
    }

    private boolean render() {
        boolean depthState = GL11.glIsEnabled((int)2929);
        if (!depthState) {
            GlStateManager.func_179126_j();
        }
        if (BladeModel.type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || BladeModel.type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || BladeModel.type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || BladeModel.type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || BladeModel.type == ItemCameraTransforms.TransformType.NONE) {
            if (BladeModel.user == null) {
                return false;
            }
            EnumSet<ItemSlashBlade.SwordType> types = BladeModel.itemBlade.getSwordType(BladeModel.targetStack);
            boolean handle = false;
            if (!types.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
                boolean bl = BladeModel.user.func_184591_cq() == EnumHandSide.RIGHT ? BladeModel.type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : (handle = BladeModel.type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
            }
            if (BladeModel.type == ItemCameraTransforms.TransformType.NONE) {
                if (this.checkRenderNaked()) {
                    this.renderNaked(true);
                } else {
                    BladeFirstPersonRender.getInstance().renderVR();
                }
            } else if (this.checkRenderNaked()) {
                this.renderNaked();
            } else {
                BladeFirstPersonRender.getInstance().render();
            }
            return false;
        }
        GL11.glPushAttrib((int)1048575);
        if (BladeModel.renderPath++ >= 1) {
            Face.setColor(-8372020);
            GL11.glMatrixMode((int)5890);
            GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
            GL11.glMatrixMode((int)5888);
        } else {
            Face.resetColor();
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)518, (float)0.05f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        float scale = 0.0095f;
        if (BladeModel.type == ItemCameraTransforms.TransformType.GUI) {
            scale = 0.008f;
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        EnumSet<ItemSlashBlade.SwordType> types = BladeModel.itemBlade.getSwordType(BladeModel.targetStack);
        WavefrontObject model = BladeModelManager.getInstance().getModel(BladeModel.itemBlade.getModelLocation(BladeModel.targetStack));
        String renderTarget = types.contains((Object)ItemSlashBlade.SwordType.Broken) ? "item_damaged" : (!types.contains((Object)ItemSlashBlade.SwordType.NoScabbard) ? "item_blade" : "item_bladens");
        model.renderPart(renderTarget);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderPart(renderTarget + "_luminous");
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        if (BladeModel.renderPath == 1 && BladeModel.type == ItemCameraTransforms.TransformType.GUI) {
            model = BladeModelManager.getInstance().getModel(BladeModelManager.resourceDurabilityModel);
            this.bindTexture(BladeModelManager.resourceDurabilityTexture);
            double par = BladeModel.itemBlade.getDurabilityForDisplay(BladeModel.targetStack);
            par = Math.min(Math.max(par, 0.0), 1.0);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.1f);
            Color4f aCol = new Color4f(new Color(0.25f, 0.25f, 0.25f, 1.0f));
            Color4f bCol = new Color4f(new Color(10824803));
            aCol.interpolate((Tuple4f)bCol, (float)par);
            Face.setColor(aCol.get().getRGB());
            model.renderPart("base");
            Face.resetColor();
            boolean isBroken = types.contains((Object)ItemSlashBlade.SwordType.Broken);
            if (isBroken) {
                GL11.glMatrixMode((int)5890);
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
                GL11.glMatrixMode((int)5888);
            }
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-2.0 * BladeModel.itemBlade.getDurabilityForDisplay(BladeModel.targetStack)));
            model.renderPart("color");
            if (isBroken) {
                GL11.glMatrixMode((int)5890);
                GlStateManager.func_179096_D();
                GL11.glMatrixMode((int)5888);
            }
        }
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        Face.resetColor();
        if (!depthState) {
            GlStateManager.func_179097_i();
        }
        return true;
    }

    private void renderNaked() {
        this.renderNaked(false);
    }

    private void renderNaked(boolean isVR) {
        EntityLivingBase entitylivingbaseIn = BladeModel.user;
        ItemStack itemstack = BladeModel.targetStack;
        ItemSlashBlade itemBlade = BladeModel.itemBlade;
        if (!itemstack.func_190926_b()) {
            ItemStack mainHnad;
            boolean isScabbard;
            Item item = itemstack.func_77973_b();
            boolean bl = isScabbard = item instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(itemstack);
            if (isScabbard && (mainHnad = entitylivingbaseIn.func_184614_ca()).func_77973_b() instanceof ItemSlashBlade) {
                EnumSet<ItemSlashBlade.SwordType> mainhandtypes = ((ItemSlashBlade)mainHnad.func_77973_b()).getSwordType(mainHnad);
                if (!mainhandtypes.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
                    itemstack = mainHnad;
                } else {
                    return;
                }
            }
            GlStateManager.func_179094_E();
            EnumSet<ItemSlashBlade.SwordType> swordType = itemBlade.getSwordType(itemstack);
            WavefrontObject model = BladeModelManager.getInstance().getModel(itemBlade.getModelLocation(itemstack));
            ResourceLocationRaw resourceTexture = itemBlade.getModelTexture(itemstack);
            this.bindTexture(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            if (isVR) {
                GL11.glTranslatef((float)-0.4f, (float)-0.1f, (float)-0.05f);
            }
            GL11.glTranslatef((float)0.5f, (float)0.3f, (float)0.55f);
            float scale = 0.008f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)0.15f, (float)0.0f);
            if (isVR) {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (isVR) {
                GL11.glRotatef((float)-43.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (isScabbard) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)75.0f, (float)0.0f, (float)0.0f);
            }
            String[] renderTargets = isScabbard ? new String[]{"sheath"} : (swordType.contains((Object)ItemSlashBlade.SwordType.Cursed) ? new String[]{"sheath", "blade"} : (swordType.contains((Object)ItemSlashBlade.SwordType.Broken) ? new String[]{"blade_damaged"} : new String[]{"blade"}));
            model.renderOnly(renderTargets);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            float lastx = OpenGlHelper.lastBrightnessX;
            float lasty = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            for (String renderTarget : renderTargets) {
                model.renderPart(renderTarget + "_luminous");
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
            GL11.glEnable((int)2896);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179121_F();
        }
    }

    private void bindTexture(ResourceLocation loc) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(loc);
    }

    private static final class SingletonHolder {
        private static final BladeSpecialRender instance = new BladeSpecialRender();

        private SingletonHolder() {
        }
    }
}

