/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.named;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.TagPropertyAccessor;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.DummyAnvilRecipe;
import mods.flammpfeil.slashblade.util.SlashBladeAchievementCreateEvent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NamedBladeManager {
    public static final List<String> keyList = Lists.newArrayList();
    public static final Map<String, ItemStack> namedbladeSouls = Maps.newHashMap();

    private static ItemStack getSoulOf(int index) {
        String key = keyList.get(index);
        if (key == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = namedbladeSouls.get(key);
        if (!stack.func_190926_b()) {
            stack = stack.func_77946_l();
        }
        return stack;
    }

    public static ItemStack getNamedSoul(Random rand) {
        if (rand == null) {
            rand = new Random();
        }
        int max = keyList.size();
        int index = rand.nextInt(max);
        return NamedBladeManager.getSoulOf(index);
    }

    public static ItemStack getNamedSoulSequential(int num) {
        int max = keyList.size();
        int index = Math.abs(num) % max;
        return NamedBladeManager.getSoulOf(index);
    }

    public static void registerBladeSoul(NBTTagCompound tag, String name) {
        ItemStack crystal = SlashBlade.findItemStack("flammpfeil.slashblade", "crystal_bladesoul", 1);
        NBTTagCompound newTag = tag.func_74737_b();
        newTag.func_82580_o("ench");
        crystal.func_77982_d(newTag);
        crystal.func_151001_c(name + " soul");
        String keyName = ItemSlashBladeNamed.CurrentItemName.get(tag);
        keyList.add(keyName);
        namedbladeSouls.put(keyName, crystal);
    }

    public static void registerBladeSoul(NBTTagCompound tag, String name, boolean addCreativeTab) {
        NamedBladeManager.registerBladeSoul(tag, name);
        if (addCreativeTab) {
            ItemStack blade = new ItemStack((Item)SlashBlade.bladeNamed, 1, 0);
            blade.func_77982_d(tag.func_74737_b());
            SlashBlade.registerCustomItemStack(blade.func_77977_a(), blade);
            ItemSlashBladeNamed.NamedBlades.add(blade.func_77977_a());
        }
    }

    @SubscribeEvent
    public void onRegisterSBAchievement(SlashBladeAchievementCreateEvent event) {
        for (Map.Entry<String, ItemStack> entry : namedbladeSouls.entrySet()) {
            ItemStack icon = SlashBlade.getCustomBlade(entry.getKey());
            if (icon.func_190926_b()) {
                TagPropertyAccessor[] accessors;
                ItemStack soul = entry.getValue();
                NBTTagCompound matTag = soul.func_77978_p();
                ItemStack targetBlade = SlashBlade.findItemStack("flammpfeil.slashblade", "slashbladeNamed", 1);
                NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(targetBlade);
                ItemSlashBladeNamed.CurrentItemName.set(tag, ItemSlashBladeNamed.CurrentItemName.get(matTag));
                if (ItemSlashBlade.BaseAttackModifier.exists(matTag)) {
                    ItemSlashBlade.setBaseAttackModifier(tag, ItemSlashBlade.BaseAttackModifier.get(matTag).floatValue());
                }
                for (TagPropertyAccessor acc : accessors = new TagPropertyAccessor[]{ItemSlashBladeNamed.CustomMaxDamage, ItemSlashBlade.TextureName, ItemSlashBlade.ModelName, ItemSlashBlade.SpecialAttackType, ItemSlashBlade.StandbyRenderType, ItemSlashBladeNamed.IsDefaultBewitched, ItemSlashBladeNamed.TrueItemName, ItemSlashBlade.SummonedSwordColor, ItemSlashBlade.IsDestructable, ItemSlashBlade.IsBroken}) {
                    this.copyTag(acc, tag, matTag);
                }
                icon = targetBlade;
            }
            if (icon.func_190926_b()) continue;
            String contentKey = entry.getKey();
            ItemStack base = SlashBlade.findItemStack("flammpfeil.slashblade", "slashbladeNamed", 1);
            SlashBlade.addRecipe(contentKey, new DummyAnvilRecipe(icon, base, entry.getValue()));
        }
    }

    public void copyTag(TagPropertyAccessor acc, NBTTagCompound dest, NBTTagCompound src) {
        if (acc.exists(src)) {
            acc.set(dest, acc.get(src));
        }
    }
}

