/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.api;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;
import org.apache.logging.log4j.Level;

public final class AoAPlayerAPI {
    public static int getLevel(String skillName, EntityPlayer player) {
        if (skillName == null || player == null) {
            return -1;
        }
        try {
            return PlayerUtil.getAdventPlayer(player).stats().getLevel(Enums.Skills.valueOf(skillName.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown skill name: " + skillName.toUpperCase() + ", dropping AoAPlayerAPI#getLevel() request.");
            ex.printStackTrace();
            return -1;
        }
    }

    public static String getArmourSet(EntityPlayer player) {
        if (player == null) {
            return "";
        }
        Enums.ArmourSets set = PlayerUtil.getAdventPlayer(player).equipment().getCurrentFullArmourSet();
        if (set == null) {
            return "";
        }
        return set.toString();
    }

    public static float getResourceValue(String resource, EntityPlayer player) {
        if (resource == null || player == null) {
            return -1.0f;
        }
        try {
            return PlayerUtil.getAdventPlayer(player).stats().getResourceValue(Enums.Resources.valueOf(resource.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown resource name: " + resource.toUpperCase() + ", dropping AoAPlayerAPI#getResourceValue() request.");
            ex.printStackTrace();
            return -1.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static float getClientResourceValue(String resource) {
        if (resource == null) {
            return -1.0f;
        }
        try {
            Enums.Resources res = Enums.Resources.valueOf(resource.toUpperCase());
            switch (res) {
                case CREATION: {
                    return AdventGuiTabPlayer.resourceCreation;
                }
                case ENERGY: {
                    return AdventGuiTabPlayer.resourceEnergy;
                }
                case RAGE: {
                    return AdventGuiTabPlayer.resourceRage;
                }
                case SOUL: {
                    return AdventGuiTabPlayer.resourceSoul;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown resource name: " + resource.toUpperCase() + ", dropping AoAPlayerAPI#getResourceValue() request.");
            ex.printStackTrace();
        }
        return -1.0f;
    }

    public static boolean consumeResource(String resource, float amount, boolean forceConsume, EntityPlayer player) {
        if (resource == null || player == null) {
            return false;
        }
        try {
            return PlayerUtil.getAdventPlayer(player).stats().consumeResource(Enums.Resources.valueOf(resource.toUpperCase()), amount, forceConsume);
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown resource name: " + resource.toUpperCase() + ", dropping AoAPlayerAPI#regenResource() request.");
            ex.printStackTrace();
            return false;
        }
    }

    public static void regenResource(String resource, float amount, EntityPlayer player) {
        if (resource == null || player == null) {
            return;
        }
        try {
            PlayerUtil.getAdventPlayer(player).stats().regenResource(Enums.Resources.valueOf(resource.toUpperCase()), Math.max(amount, 0.0f));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown resource name: " + resource.toUpperCase() + ", dropping AoAPlayerAPI#regenResource() request.");
            ex.printStackTrace();
        }
    }

    public static int getTributeValue(String deityName, EntityPlayer player) {
        if (deityName == null || player == null) {
            return -1;
        }
        try {
            return PlayerUtil.getAdventPlayer(player).stats().getTribute(Enums.Deities.valueOf(deityName.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown deity name: " + deityName.toUpperCase() + ", dropping AoAPlayerAPI#getTributeValue() request.");
            ex.printStackTrace();
            return -1;
        }
    }

    public static void increaseTribute(String deityName, int amount, EntityPlayer player) {
        if (deityName == null || player == null) {
            return;
        }
        try {
            PlayerUtil.getAdventPlayer(player).stats().addTribute(Enums.Deities.valueOf(deityName.toUpperCase()), Math.max(0, amount));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown deity name: " + deityName.toUpperCase() + ", dropping AoAPlayerAPI#increaseTribute() request.");
            ex.printStackTrace();
        }
    }

    public static EntityLivingBase getVulcaneTarget(EntityPlayer player) {
        return player != null ? PlayerUtil.getAdventPlayer(player).getRevengeTarget() : null;
    }

    public static void setRevengeTarget(EntityLivingBase target, EntityPlayer player) {
        if (target == null || player == null) {
            return;
        }
        PlayerUtil.getAdventPlayer(player).enableRevenge(target);
    }

    public static void endRevenge(EntityPlayer player) {
        if (player == null) {
            return;
        }
        PlayerUtil.getAdventPlayer(player).disableRevenge();
    }

    public static float getCurrentXp(String skillName, EntityPlayer player) {
        if (skillName == null || player == null) {
            return -1.0f;
        }
        try {
            return PlayerUtil.getAdventPlayer(player).stats().getExp(Enums.Skills.valueOf(skillName.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown skill name: " + skillName.toUpperCase() + ", dropping AoAPlayerAPI#getCurrentXp() request.");
            ex.printStackTrace();
            return -1.0f;
        }
    }

    public static float getXpToNextLevel(String skillName, EntityPlayer player) {
        if (skillName == null || player == null) {
            return -1.0f;
        }
        try {
            return PlayerUtil.getXpRemainingUntilLevel(PlayerUtil.getAdventPlayer(player), Enums.Skills.valueOf(skillName.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Unknown skill name: " + skillName.toUpperCase() + ", dropping AoAPlayerAPI#getCurrentXp() request.");
            ex.printStackTrace();
            return -1.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getPercentLevelComplete(String skillName) {
        if (skillName == null) {
            return -1;
        }
        try {
            return AdventGuiTabPlayer.getPercentCompleteLevel(Enums.Skills.valueOf(skillName.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.WARN, "Invalid skill name request getPercentLevelComplete API call: " + skillName);
            return -1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getClientSkillLevel(String skillName, boolean includeVanityLevels) {
        if (skillName == null) {
            return -1;
        }
        try {
            Enums.Skills skill = Enums.Skills.valueOf(skillName.toUpperCase());
            int lvl = AdventGuiTabPlayer.getSkillLevel(skill);
            return ConfigurationUtil.MainConfig.showVanityLevels && includeVanityLevels ? lvl : Math.min(lvl, 100);
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.WARN, "Invalid skill name request getClientSkillLevel API call: " + skillName);
            return -1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static float getClientSkillXp(String skillName) {
        if (skillName == null) {
            return -1.0f;
        }
        try {
            return AdventGuiTabPlayer.getSkillXp(Enums.Skills.valueOf(skillName.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            AdventOfAscension.logMessage(Level.WARN, "Invalid skill name request getClientSkillXp API call: " + skillName);
            return -1.0f;
        }
    }
}

