/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.decoration.banner;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.utils.EntityUtil;

public class BannerBlock
extends Block {
    private static final PropertyEnum<BannerType> TYPE = PropertyEnum.func_177709_a((String)"type", BannerType.class);
    private static final AxisAlignedBB MOUNTED_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.15625);
    private static final AxisAlignedBB MOUNTED_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.84375, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB MOUNTED_EAST_AABB = new AxisAlignedBB(0.84375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB MOUNTED_WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.15625, 1.0, 1.0);
    private static final AxisAlignedBB STANDING_NORTH_AABB = new AxisAlignedBB(0.1875, 0.0, 0.453125, 0.8125, 1.0, 0.609375);
    private static final AxisAlignedBB STANDING_SOUTH_AABB = new AxisAlignedBB(0.1875, 0.0, 0.390625, 0.8125, 1.0, 0.546875);
    private static final AxisAlignedBB STANDING_EAST_AABB = new AxisAlignedBB(0.390625, 0.0, 0.1875, 0.546875, 1.0, 0.8125);
    private static final AxisAlignedBB STANDING_WEST_AABB = new AxisAlignedBB(0.453125, 0.0, 0.1875, 0.609375, 1.0, 0.8125);

    public BannerBlock(String name, String registryName) {
        super(Material.field_151580_n);
        this.func_149663_c(name);
        this.setRegistryName("aoa3:" + registryName);
        this.func_149711_c(1.5f);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)BannerType.MOUNTED)).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(CreativeTabsRegister.bannersTab);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(TYPE) == BannerType.STANDING) {
            switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
                case NORTH: {
                    return STANDING_NORTH_AABB;
                }
                case SOUTH: {
                    return STANDING_SOUTH_AABB;
                }
                case EAST: {
                    return STANDING_EAST_AABB;
                }
                case WEST: {
                    return STANDING_WEST_AABB;
                }
            }
        } else {
            switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
                case NORTH: {
                    return MOUNTED_NORTH_AABB;
                }
                case SOUTH: {
                    return MOUNTED_SOUTH_AABB;
                }
                case EAST: {
                    return MOUNTED_EAST_AABB;
                }
                case WEST: {
                    return MOUNTED_WEST_AABB;
                }
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(TYPE) == BannerType.MOUNTED) {
            if (!worldIn.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D))).func_185904_a().func_76220_a()) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        } else if (!worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                if (!world.func_180495_p(pos.func_177972_a(side.func_176734_d())).func_185917_h()) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j()) break;
                return false;
            }
            case DOWN: {
                return false;
            }
            case UP: {
                if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j()) break;
                return false;
            }
        }
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        switch (facing) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BannerType.MOUNTED)).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing.func_176734_d());
            }
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BannerType.STANDING)).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EntityUtil.getDirectionFacing((Entity)placer, true));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, BlockHorizontal.field_185512_D});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((BannerType)((Object)state.func_177229_b(TYPE))).getMetaMuliplier();
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            case NORTH: {
                return meta;
            }
            case SOUTH: {
                return meta * 3;
            }
            case EAST: {
                return meta * 5;
            }
            case WEST: {
                return meta * 7;
            }
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta % 2 == 0) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)BannerType.STANDING));
            switch (meta / 2) {
                case 0: 
                case 1: {
                    return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH);
                }
                case 3: {
                    return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH);
                }
                case 5: {
                    return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.EAST);
                }
                case 7: {
                    return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST);
                }
            }
        } else {
            state = state.func_177226_a(TYPE, (Comparable)((Object)BannerType.MOUNTED));
            switch (meta) {
                case 1: {
                    return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH);
                }
                case 3: {
                    return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH);
                }
                case 5: {
                    return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.EAST);
                }
                case 7: {
                    return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST);
                }
            }
        }
        return state.func_177226_a(TYPE, (Comparable)((Object)BannerType.STANDING)).func_177226_a(TYPE, (Comparable)((Object)BannerType.MOUNTED));
    }

    private static enum BannerType implements IStringSerializable
    {
        MOUNTED("mounted"),
        STANDING("standing");

        private final String name;

        private BannerType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetaMuliplier() {
            return this == MOUNTED ? 1 : 2;
        }

        public static BannerType getByMeta(int meta) {
            return meta == 1 ? MOUNTED : STANDING;
        }
    }
}

