/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.decoration.slabs;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;

public abstract class SlabBlock
extends BlockSlab {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private HalfSlabBlock halfBlock;

    public SlabBlock(String name, String registryName, Material material) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName("aoa3:" + (this.func_176552_j() ? "double_" : "") + registryName);
        this.func_149711_c(2.0f);
        this.field_149783_u = !this.func_176552_j();
        IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT));
        if (!this.func_176552_j()) {
            state.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
            this.halfBlock = (HalfSlabBlock)this;
        }
        if (material == Material.field_151575_d) {
            Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
            this.func_149752_b(5.0f);
            this.func_149672_a(SoundType.field_185848_a);
        } else if (material == Material.field_151576_e) {
            this.func_149752_b(10.0f);
            this.func_149672_a(SoundType.field_185851_d);
        }
        this.func_180632_j(state);
        this.func_149647_a(CreativeTabsRegister.decorationBlocksTab);
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.halfBlock);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this.halfBlock);
    }

    public HalfSlabBlock getHalfBlock() {
        if (this.halfBlock != null) {
            return this.halfBlock;
        }
        this.halfBlock = new HalfSlabBlock(this.func_149739_a().replace("tile.", ""), this.getRegistryName().toString().replace("aoa3:double_", ""), this.func_149688_o(this.func_176223_P()));
        return this.halfBlock;
    }

    public final IBlockState func_176203_a(int meta) {
        IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT));
        if (!this.func_176552_j()) {
            state = state.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) != 0 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
        }
        return state;
    }

    public final int func_176201_c(IBlockState state) {
        int meta = 0;
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        if (!this.func_176552_j()) {
            return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176554_a});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void setHalfBlock(HalfSlabBlock block) {
        this.halfBlock = block;
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }

    public static class HalfSlabBlock
    extends SlabBlock {
        public HalfSlabBlock(String name, String registryName, Material material) {
            super(name, registryName, material);
        }

        public boolean func_176552_j() {
            return false;
        }
    }

    public static class DoubleSlabBlock
    extends SlabBlock {
        public DoubleSlabBlock(String name, String registryName, Material material) {
            super(name, registryName, material);
        }

        public boolean func_176552_j() {
            return true;
        }

        public DoubleSlabBlock registerHalfSlab(IForgeRegistry<Block> registry) {
            HalfSlabBlock halfSlab = new HalfSlabBlock(this.func_149739_a().replace("tile.", ""), this.getRegistryName().toString().replace("aoa3:double_", ""), this.func_149688_o(this.func_176223_P()));
            this.setHalfBlock(halfSlab);
            registry.register((IForgeRegistryEntry)halfSlab);
            return this;
        }
    }
}

