/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.altar;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.entity.boss.primordialfive.EntityKajaros;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class PrimordialShrine
extends BossAltarBlock {
    public PrimordialShrine() {
        super("PrimordialShrine", "primordial_shrine");
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            PlayerUtil.getAdventPlayer(player).sendThrottledChatMessage("message.feedback.spawnBoss.difficultyFail", new Object[0]);
            return false;
        }
        if (!world.field_72995_K && this.checkActivationConditions(player, hand, state, pos)) {
            this.doActivationEffect(player, hand, state, pos);
        }
        return true;
    }

    @Override
    protected boolean checkActivationConditions(EntityPlayer player, EnumHand hand, IBlockState state, BlockPos pos) {
        World world = player.field_70170_p;
        BlockPos lamp1 = pos.func_177981_b(1).func_177985_f(3).func_177964_d(5);
        BlockPos lamp2 = lamp1.func_177970_e(10);
        BlockPos lamp3 = pos.func_177981_b(1).func_177985_f(1).func_177964_d(4);
        BlockPos lamp4 = lamp3.func_177970_e(8);
        BlockPos lamp5 = pos.func_177981_b(3).func_177964_d(3).func_177965_g(1);
        BlockPos lamp6 = lamp5.func_177970_e(6);
        BlockPos lamp7 = pos.func_177981_b(5).func_177964_d(1).func_177965_g(1);
        BlockPos lamp8 = lamp7.func_177970_e(2);
        return world.func_180495_p(lamp1).func_177230_c() == BlockRegister.dustopianLamp && world.func_180495_p(lamp2).func_177230_c() == BlockRegister.dustopianLamp && world.func_180495_p(lamp3).func_177230_c() == BlockRegister.dustopianLamp && world.func_180495_p(lamp4).func_177230_c() == BlockRegister.dustopianLamp && world.func_180495_p(lamp5).func_177230_c() == BlockRegister.dustopianLamp && world.func_180495_p(lamp6).func_177230_c() == BlockRegister.dustopianLamp && world.func_180495_p(lamp7).func_177230_c() == BlockRegister.dustopianLamp && world.func_180495_p(lamp8).func_177230_c() == BlockRegister.dustopianLamp;
    }

    @Override
    protected void doActivationEffect(EntityPlayer player, EnumHand hand, IBlockState state, BlockPos blockPos) {
        World world = player.field_70170_p;
        IBlockState lampOff = BlockRegister.dustopianLampOff.func_176223_P();
        switch (player.func_70681_au().nextInt(8)) {
            case 0: {
                world.func_175656_a(blockPos.func_177984_a().func_177985_f(3).func_177964_d(5), lampOff);
                break;
            }
            case 1: {
                world.func_175656_a(blockPos.func_177984_a().func_177985_f(3).func_177970_e(5), lampOff);
                break;
            }
            case 2: {
                world.func_175656_a(blockPos.func_177984_a().func_177976_e().func_177964_d(4), lampOff);
                break;
            }
            case 3: {
                world.func_175656_a(blockPos.func_177984_a().func_177976_e().func_177970_e(4), lampOff);
                break;
            }
            case 4: {
                world.func_175656_a(blockPos.func_177981_b(3).func_177964_d(3).func_177974_f(), lampOff);
                break;
            }
            case 5: {
                world.func_175656_a(blockPos.func_177981_b(3).func_177970_e(3).func_177974_f(), lampOff);
                break;
            }
            case 6: {
                world.func_175656_a(blockPos.func_177981_b(5).func_177978_c().func_177974_f(), lampOff);
                break;
            }
            case 7: {
                world.func_175656_a(blockPos.func_177981_b(5).func_177968_d().func_177974_f(), lampOff);
            }
        }
        EntityKajaros kajaros = new EntityKajaros(player.field_70170_p);
        kajaros.func_70012_b(blockPos.func_177958_n(), blockPos.func_177956_o() + 3, blockPos.func_177952_p(), 0.0f, 0.0f);
        player.field_70170_p.func_72838_d((Entity)kajaros);
        this.sendSpawnMessage(player, StringUtil.getLocaleWithArguments("message.mob.primordialFive.spawn", player.getDisplayNameString()), blockPos);
    }

    @Override
    protected Item getActivationItem() {
        return null;
    }
}

