/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.generation.ores;

import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;

@Mod.EventBusSubscriber
public class OverworldOre
extends BlockOre {
    private static final PropertyEnum<OreType> variant = PropertyEnum.func_177709_a((String)"ore", OreType.class);

    public OverworldOre() {
        this.func_149663_c("OverworldOre");
        this.setRegistryName("aoa3:overworld_ore");
        this.func_149647_a(CreativeTabsRegister.generationBlocksTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(variant, (Comparable)((Object)OreType.LIMONITE)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{variant});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(variant, (Comparable)((Object)OreType.getByMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((OreType)((Object)state.func_177229_b(variant))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public String getName(ItemStack stack) {
        return OreType.getByMeta(stack.func_77960_j()).func_176610_l();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> blocks) {
        for (OreType ore : OreType.values()) {
            blocks.add((Object)new ItemStack((Block)this, 1, ore.getMeta()));
        }
    }

    public static enum OreType implements IStringSerializable
    {
        LIMONITE(0, "limonite"),
        SAPPHIRE(1, "sapphire"),
        JADE(2, "jade"),
        ROSITE(3, "rosite"),
        AMETHYST(4, "amethyst"),
        RUNIUM(5, "runium");

        private final int meta;
        private final String oreName;

        private OreType(int meta, String name) {
            this.meta = meta;
            this.oreName = name;
        }

        public static OreType getByMeta(int meta) {
            switch (meta) {
                case 0: {
                    return LIMONITE;
                }
                case 1: {
                    return SAPPHIRE;
                }
                case 2: {
                    return JADE;
                }
                case 3: {
                    return ROSITE;
                }
                case 4: {
                    return AMETHYST;
                }
                case 5: {
                    return RUNIUM;
                }
            }
            return null;
        }

        public String func_176610_l() {
            return this.oreName;
        }

        public int getMeta() {
            return this.meta;
        }

        public static String[] getAllNames() {
            String[] names = new String[OreType.values().length];
            for (OreType ore : OreType.values()) {
                names[ore.getMeta()] = ore.func_176610_l();
            }
            return names;
        }
    }
}

